/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.samples.pubsub.EventsLogger;
import org.atmosphere.samples.pubsub.JAXBBean;
import org.atmosphere.util.StringFilterAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{topic}")
@Produces(value={"text/plain;charset=ISO-8859-1"})
public class PubSub {
    private static final Logger logger = LoggerFactory.getLogger(PubSub.class);
    @PathParam(value="topic")
    private Broadcaster broadcaster;

    @PreDestroy
    public void destroy() {
        logger.info("Testing the @PreDestroy");
    }

    @GET
    @Suspend(listeners={EventsLogger.class})
    public Broadcastable subscribe() {
        return new Broadcastable(this.broadcaster);
    }

    @GET
    @Path(value="subscribeAndUsingExternalThread")
    @Suspend(resumeOnBroadcast=true, listeners={EventsLogger.class})
    public String subscribeAndResumeUsingExternalThread(@PathParam(value="topic") String topic) {
        Executors.newSingleThreadExecutor().submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return "foo";
    }

    @GET
    @Suspend(resumeOnBroadcast=true, listeners={EventsLogger.class})
    @Path(value="subscribeAndResume")
    public Broadcastable subscribeAndResume() {
        return new Broadcastable(this.broadcaster);
    }

    @POST
    @Produces(value={"application/xml"})
    @Broadcast
    public Broadcastable publishWithXML(@FormParam(value="message") String message) {
        return new Broadcastable((Object)new JAXBBean(message), this.broadcaster);
    }

    @POST
    @Broadcast
    public Broadcastable publish(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @POST
    @Broadcast(filters={StringFilterAggregator.class})
    @Path(value="aggregate")
    public Broadcastable aggregate(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Schedule(period=5, resumeOnBroadcast=true)
    @POST
    @Path(value="scheduleAndResume")
    public Broadcastable scheduleAndResume(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Schedule(period=10, waitFor=5)
    @POST
    @Path(value="delaySchedule")
    public Broadcastable delaySchedule(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Schedule(period=5)
    @POST
    @Path(value="schedule")
    public Broadcastable schedule(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Broadcast(delay=5)
    @POST
    @Path(value="delay")
    public Broadcastable delayPublish(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Broadcast(delay=5, resumeOnBroadcast=true)
    @POST
    @Path(value="delayAndResume")
    public Broadcastable delayPublishAndResume(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @Path(value="buffer")
    @POST
    @Broadcast(delay=0)
    public Broadcastable buffer(@FormParam(value="message") String message) {
        return this.broadcast(message);
    }

    @POST
    @Path(value="broadcast")
    public String manualDelayBroadcast(@FormParam(value="message") String message) {
        this.broadcaster.delayBroadcast((Object)message, 10L, TimeUnit.SECONDS);
        return message;
    }

    @GET
    @Suspend(period=60, timeUnit=TimeUnit.SECONDS, listeners={EventsLogger.class})
    @Path(value="timeout")
    public Broadcastable timeout() {
        return new Broadcastable(this.broadcaster);
    }

    Broadcastable broadcast(String m) {
        return new Broadcastable((Object)(m + "\n"), this.broadcaster);
    }

    static /* synthetic */ Broadcaster access$000(PubSub x0) {
        return x0.broadcaster;
    }
}

