/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.atmosphere.core.annotation.Broadcast;
import org.atmosphere.core.annotation.Suspend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/chat")
public class ResourceChat {
    private static final String BEGIN_SCRIPT_TAG = "<script type='text/javascript'>\n";
    private static final String END_SCRIPT_TAG = "</script>\n";

    @Suspend
    @GET
    @Produces(value={"text/html"})
    public String cometGet() {
        return "<!-- Comet is a programming technique that enables web servers to send data to the client without having any need for the client to request it. -->\n";
    }

    @Broadcast
    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    @Produces(value={"text/html"})
    public String cometPost(MultivaluedMap<String, String> form) {
        String action = (String)form.getFirst((Object)"action");
        String name = (String)form.getFirst((Object)"name");
        if ("login".equals(action)) {
            return BEGIN_SCRIPT_TAG + this.toJsonp("System Message", name + " has joined.") + END_SCRIPT_TAG;
        }
        if ("post".equals(action)) {
            return BEGIN_SCRIPT_TAG + this.toJsonp(name, (String)form.getFirst((Object)"message")) + END_SCRIPT_TAG;
        }
        throw new WebApplicationException(422);
    }

    private String escape(String orig) {
        StringBuffer buffer = new StringBuffer(orig.length());
        block13: for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    continue block13;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block13;
                }
                case '\n': {
                    buffer.append("<br />");
                    continue block13;
                }
                case '\r': {
                    continue block13;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block13;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block13;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block13;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block13;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block13;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block13;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block13;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private String toJsonp(String name, String message) {
        return "window.parent.app.update({ name: \"" + this.escape(name) + "\", message: \"" + this.escape(message) + "\" });\n";
    }
}

