/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.rest.counter;

import com.sun.jersey.spi.resource.Singleton;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.atmosphere.core.annotation.ResumeOnBroadcast;
import org.atmosphere.core.annotation.Suspend;

@Path(value="{counter}")
@Singleton
public class RestLongPolling {
    private final AtomicInteger counter = new AtomicInteger();

    @GET
    @Suspend
    public String suspend() {
        System.out.println("Suspending");
        return "";
    }

    @POST
    @Path(value="{counter}")
    @ResumeOnBroadcast
    public String increment(@PathParam(value="counter") String count) {
        System.out.println("Broadcasting and resuming: " + count);
        this.counter.incrementAndGet();
        return this.counter.toString();
    }
}

