/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.rest.counter;

import com.sun.jersey.spi.resource.Singleton;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Resume;
import org.atmosphere.annotation.Suspend;

@Path(value="{counter}")
@Singleton
public class RestLongPolling {
    private final AtomicInteger counter = new AtomicInteger();

    @Suspend
    @GET
    @Produces(value={"text/html;charset=ISO-8859-1"})
    public String suspend() {
        return "";
    }

    @POST
    @Path(value="{counter}")
    @Broadcast(resumeOnBroadcast=true)
    public String increment(@PathParam(value="counter") String count) {
        System.out.println("Broadcasting and resuming: " + count);
        this.counter.incrementAndGet();
        return this.counter.toString();
    }

    @GET
    @Path(value="/{uuid}")
    @Resume
    public String resume() {
        System.out.println("Resuming");
        return "Resumed";
    }
}

