/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.twitter;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import org.atmosphere.samples.twitter.UsersState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);
    private final UsersState us;
    private String user;
    private UsersState.UserStateData usd;

    public UserResource(UsersState us, String name, UsersState.UserStateData usd) {
        this.us = us;
        this.user = name;
        this.usd = usd;
    }

    @GET
    public String get() {
        return "";
    }

    @DELETE
    public void delete() {
        this.us.remove(this.user);
    }

    @Path(value="messages")
    @POST
    public void post(String message) {
        logger.info("MESSAGE: {}", (Object)message);
    }

    @Path(value="follows")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void follow(@FormParam(value="follower") String follower) {
        UsersState.UserStateData followerState = this.us.get(follower);
        if (followerState == null) {
            throw new WebApplicationException(404);
        }
        followerState.bc.addAtmosphereResource(this.us.get((String)this.user).bc.getUserAtmosphereEvent().getResource());
        followerState.bc.broadcast((Object)(this.user + " is now follow you "), followerState.bc.getUserAtmosphereEvent().getResource());
        logger.info("{} is following {}", (Object)this.user, (Object)follower);
    }
}

