/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.twitter;

import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.samples.twitter.TwitterBroadcaster;
import org.atmosphere.samples.twitter.UsersState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/twitter")
@Singleton
public class TwitterResource {
    private static final Logger logger = LoggerFactory.getLogger(TwitterResource.class);
    private int counter;
    private static final String BEGIN_SCRIPT_TAG = "<script type='text/javascript'>\n";
    private static final String END_SCRIPT_TAG = "</script>\n";
    private static final long serialVersionUID = -2919167206889576860L;
    private String startingMessage = "<html><head><title>Twitter</title></head><body bgcolor=\"#FFFFFF\">";
    private UsersState us = new UsersState();

    @Suspend(scope=Suspend.SCOPE.REQUEST)
    @GET
    @Produces(value={"text/html;charset=ISO-8859-1"})
    public String onStart(@QueryParam(value="callback") String callback) {
        String message = "{ message : 'Welcome'}";
        if (callback == null) {
            callback = "alert";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.startingMessage);
        sb.append("<script id='comet_" + this.counter++ + "'>" + "window.parent." + callback + "(" + message + ");</script>\n");
        return sb.toString();
    }

    @Path(value="login")
    @Broadcast
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain;charset=ISO-8859-1"})
    public Broadcastable onLogin(@Context TwitterBroadcaster bc, @FormParam(value="name") String name) {
        UsersState.UserStateData usd = this.us.create(name, bc);
        if (usd == null) {
            throw new WebApplicationException(400);
        }
        if (name == null) {
            logger.error("Name cannot be null");
            throw new WebApplicationException(400);
        }
        bc.setID(name);
        String m = BEGIN_SCRIPT_TAG + this.toJsonp("Welcome back", name) + END_SCRIPT_TAG;
        Broadcastable b = new Broadcastable((Object)m, (Broadcaster)bc);
        return b;
    }

    @Path(value="follows")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html;charset=ISO-8859-1"})
    @Broadcast
    public Broadcastable onFollow(@Context TwitterBroadcaster userBc, @FormParam(value="name") String name, @FormParam(value="followee") String followee) {
        if (followee == null) {
            logger.error("Message cannot be null");
            throw new WebApplicationException(400);
        }
        if (name == null) {
            logger.error("Name cannot be null");
            throw new WebApplicationException(400);
        }
        UsersState.UserStateData followeeData = this.us.get(followee);
        TwitterBroadcaster outsiderBroadcaster = followeeData.bc;
        if (outsiderBroadcaster == null) {
            String m = BEGIN_SCRIPT_TAG + this.toJsonp("Invalid Twitter user ", followee) + END_SCRIPT_TAG;
            Broadcastable b = new Broadcastable((Object)m, (Broadcaster)userBc);
            return b;
        }
        outsiderBroadcaster.broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp(name, " is now following " + followee) + END_SCRIPT_TAG));
        outsiderBroadcaster.addAtmosphereResource(userBc.getUserAtmosphereEvent().getResource());
        String m = BEGIN_SCRIPT_TAG + this.toJsonp("You are now following ", followee) + END_SCRIPT_TAG;
        Broadcastable b = new Broadcastable((Object)m, (Broadcaster)userBc);
        return b;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html;charset=ISO-8859-1"})
    @Broadcast
    public Broadcastable onPush(@Context TwitterBroadcaster bc, @FormParam(value="message") String message, @FormParam(value="callback") String callback) {
        if (message == null) {
            logger.error("Message cannot be null");
            throw new WebApplicationException(400);
        }
        if (callback == null) {
            callback = "alert";
        }
        String m = "<script id='comet_" + this.counter++ + "'>" + "window.parent." + callback + "(" + message + ");</script>";
        Broadcastable b = new Broadcastable((Object)m, (Broadcaster)bc);
        return b;
    }

    private String escape(String orig) {
        StringBuilder buffer = new StringBuilder(orig.length());
        block13: for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    continue block13;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block13;
                }
                case '\n': {
                    buffer.append("<br />");
                    continue block13;
                }
                case '\r': {
                    continue block13;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block13;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block13;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block13;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block13;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block13;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block13;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block13;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private String toJsonp(String name, String message) {
        return "window.parent.app.update({ name: \"" + this.escape(name) + "\", message: \"" + this.escape(message) + "\" });\n";
    }
}

