/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.servlet.resources;

import com.sun.jersey.api.representation.Form;
import java.net.URL;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/resource3/{arg1}/{arg2}")
public class ResourceBean3 {
    @Context
    UriInfo uriInfo;
    int count = 0;

    @POST
    public void doPost() {
        System.out.println("ResourceBean3 POST");
    }

    @GET
    public Response doGet() {
        MultivaluedMap params = this.uriInfo.getPathParameters();
        String arg1 = (String)params.getFirst((Object)"arg1");
        String arg2 = (String)params.getFirst((Object)"arg2");
        for (String key : this.uriInfo.getQueryParameters().keySet()) {
            System.out.println("key: " + key + " value: " + (String)this.uriInfo.getQueryParameters().getFirst((Object)key));
        }
        int rep = Integer.parseInt((String)this.uriInfo.getQueryParameters().getFirst((Object)"rep"));
        String help = "<pre>Received args: arg1: " + arg1 + " arg2: " + arg2 + "\n" + "Please specify a \"rep\" queryParameter using one of the following values\n" + "For example, http://localhost:/rest/test2/arg1/arg2?rep=1\n" + "Valid Representations:\n" + "\t0 - StringRepresentation of this message\n" + "\t1 - StringRepresentation\n" + "\t2 - FormURLEncodedRepresentation\n" + "\t3 - DataSourceRepresentation\n</pre>";
        Response r = null;
        System.out.println("rep: " + rep);
        switch (rep) {
            case 0: {
                r = Response.ok((Object)help, (String)"text/plain").header("resource3-header", (Object)"text/plain").build();
                break;
            }
            case 1: {
                r = Response.ok((Object)this.getStringRep(arg1, arg2), (String)"text/plain").header("resource3-header", (Object)"text/plain").build();
                break;
            }
            case 2: {
                r = Response.ok((Object)this.getFormURLEncodedRep(arg1, arg2), (String)"application/x-www-form-urlencoded").header("resource3-header", (Object)"application/x-www-form-urlencoded").build();
                break;
            }
            case 3: {
                r = Response.ok((Object)this.getImageRep(), (String)"image/jpg").header("resource3-header", (Object)"image/jpg").build();
                break;
            }
            default: {
                r = Response.ok((Object)help, (String)"text/plain").build();
            }
        }
        return r;
    }

    @Produces(value={"text/plain"})
    @GET
    public String getStringRep(@PathParam(value="arg1") String arg1, @PathParam(value="arg2") String arg2) {
        return "representation: StringRepresentation: arg1: " + arg1 + " arg2: " + arg2 + "\n\n";
    }

    @Produces(value={"application/x-www-form-urlencoded"})
    @GET
    public Form getFormURLEncodedRep(@PathParam(value="arg1") String arg1, @PathParam(value="arg2") String arg2) {
        Form urlProps = new Form();
        urlProps.add("representation", "FormURLEncodedRepresentation");
        urlProps.add("name", "Master Duke");
        urlProps.add("sex", "male");
        urlProps.add("arg1", arg1);
        urlProps.add("arg2", arg2);
        return urlProps;
    }

    @Produces(value={"image/jpg"})
    @GET
    public DataSource getImageRep() {
        URL jpgURL = this.getClass().getResource("java.jpg");
        return new FileDataSource(jpgURL.getFile());
    }
}

