/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import org.atmosphere.cache.SessionBroadcasterCache;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.samples.chat.SocketIOChatAtmosphereHandler;
import org.atmosphere.util.ExcludeSessionBroadcaster;

@AtmosphereHandlerService(path="/chat", interceptors={AtmosphereResourceLifecycleInterceptor.class}, broadcasterCache=SessionBroadcasterCache.class, broadcaster=ExcludeSessionBroadcaster.class)
public class SocketIOChatAtmosphereHandler
implements AtmosphereHandler {
    public void onRequest(AtmosphereResource r) throws IOException {
        r.getBroadcaster().broadcast((Object)r.getRequest().getReader().readLine());
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        AtmosphereResource r = event.getResource();
        AtmosphereResponse res = r.getResponse();
        if (event.isSuspended() && event.getMessage() != null) {
            String body = event.getMessage().toString();
            String author = body.substring(body.indexOf(":") + 2, body.indexOf(",") - 1);
            String message = body.substring(body.lastIndexOf(":") + 2, body.length() - 2);
            res.getWriter().write(new Data(author, message).toString());
        }
    }

    public void destroy() {
    }
}

