/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.comet.concurrent.DefaultConcurrentCometHandler;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometContext<E> {
    protected static final String INVALID_COMET_HANDLER = "CometHandler cannot be null. This CometHandler was probably resumed and an invalid reference was made to it.";
    protected static final String ALREADY_REMOVED = "CometHandler already been removed or invalid.";
    protected static final Logger logger = SelectorThread.logger();
    private final ConcurrentHashMap attributes;
    protected String topic;
    protected int continuationType = 1;
    private long expirationDelay;
    protected boolean blockingNotification;
    protected NotificationHandler notificationHandler;
    private volatile long nextidleclear;
    protected final ConcurrentHashMap<CometHandler, CometTask> handlers;
    protected final CometEvent eventInterrupt;
    protected final CometEvent eventTerminate;
    private final CometEvent eventInitialize;
    private static final IllegalStateException ISE = new IllegalStateException("CometHandler cannot be null. This CometHandler was probably resumed and an invalid reference was made to it.");
    private static final IllegalStateException cometNotEnabled = new IllegalStateException("Make sure you have enabled Comet or make sure the Thread invoking that method is the same as the Servlet.service() Thread.");

    public CometContext(String topic, int continuationType) {
        this.topic = topic;
        this.continuationType = continuationType;
        this.attributes = new ConcurrentHashMap();
        this.handlers = new ConcurrentHashMap(16, 0.75f, 64);
        this.eventInterrupt = new CometEvent(0, this);
        this.eventInitialize = new CometEvent(2, this);
        this.eventTerminate = new CometEvent<CometContext>(3, this, this);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.blockingNotification = false;
        this.expirationDelay = 30000L;
        this.nextidleclear = 0L;
    }

    public String getContextPath() {
        return this.getTopic();
    }

    public String getTopic() {
        return this.topic;
    }

    public void addAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public int addCometHandler(CometHandler handler, boolean alreadySuspended) {
        if (handler == null) {
            throw ISE;
        }
        if (!CometEngine.getEngine().isCometEnabled()) {
            throw cometNotEnabled;
        }
        CometTask cometTask = new CometTask(this, handler);
        cometTask.upcoming_op_isread = alreadySuspended;
        CometEngine.updatedContexts.set(cometTask);
        return handler.hashCode();
    }

    public int addCometHandler(CometHandler handler) {
        return this.addCometHandler(handler, false);
    }

    @Deprecated
    public CometHandler getCometHandler(int hashCode) {
        for (CometHandler handler : this.handlers.keySet()) {
            if (handler.hashCode() != hashCode) continue;
            return handler;
        }
        return null;
    }

    public void recycle() {
        try {
            this.notify((Object)this, 3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handlers.clear();
        this.attributes.clear();
        this.topic = null;
        this.notificationHandler = null;
        this.initDefaultValues();
        CometEngine.cometEngine.cometContextCache.offer(this);
    }

    protected void addActiveHandler(CometTask cometTask) {
        this.handlers.put(cometTask.cometHandler, cometTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCometHandler(CometEvent event, CometHandler cometHandler) throws IOException {
        if (cometHandler == null) {
            throw ISE;
        }
        event.setCometContext(this);
        if (cometHandler instanceof DefaultConcurrentCometHandler) {
            ((DefaultConcurrentCometHandler)cometHandler).EnQueueEvent(event);
        } else {
            CometHandler cometHandler2 = cometHandler;
            synchronized (cometHandler2) {
                cometHandler.onEvent(event);
            }
        }
    }

    public boolean removeCometHandler(CometHandler handler) {
        return this.removeCometHandler(handler, true);
    }

    public boolean removeCometHandler(CometHandler handler, boolean resume) {
        CometTask task = this.handlers.remove(handler);
        if (task != null) {
            if (resume) {
                CometEngine.getEngine().flushPostExecute(task, false);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeCometHandler(int hashCode) {
        CometHandler handler_ = null;
        for (CometHandler handler : this.handlers.keySet()) {
            if (handler.hashCode() != hashCode) continue;
            handler_ = handler;
            break;
        }
        if (handler_ != null) {
            return this.handlers.remove(handler_) != null;
        }
        return false;
    }

    public boolean resumeCometHandler(CometHandler handler) {
        boolean status = CometEngine.getEngine().interrupt(this.handlers.get(handler), false);
        if (status) {
            try {
                handler.onTerminate(this.eventTerminate);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return status;
    }

    public boolean isActive(CometHandler handler) {
        return this.handlers.containsKey(handler);
    }

    protected ConcurrentHashMap<CometHandler, CometTask> handlers() {
        return this.handlers;
    }

    public void notify(Object attachment) throws IOException {
        this.notify(attachment, 1);
    }

    public void notify(Object attachment, int eventType, int cometHandlerID) throws IOException {
        this.notify(attachment, eventType, this.getCometHandler(cometHandlerID));
    }

    public void notify(Object attachment, CometHandler cometHandler) throws IOException {
        this.notify(attachment, 1, cometHandler);
    }

    public void notify(Object attachment, int eventType, CometHandler cometHandler) throws IOException {
        if (cometHandler == null) {
            throw ISE;
        }
        CometEvent<Object> event = new CometEvent<Object>(eventType, this, attachment);
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, cometHandler);
        if (event.getType() != 3 && event.getType() != 0) {
            this.resetSuspendIdleTimeout();
        }
    }

    public void notify(Object attachment, int eventType) throws IOException {
        CometEvent<Object> event = new CometEvent<Object>(eventType, this, attachment);
        Iterator<CometHandler> iterator = this.handlers.keySet().iterator();
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, iterator);
        if (event.getType() != 3 && event.getType() != 0) {
            this.resetSuspendIdleTimeout();
        }
    }

    protected void initialize(CometHandler handler) throws IOException {
        handler.onInitialize(this.eventInitialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetSuspendIdleTimeout() {
        long timestamp;
        if (this.expirationDelay != -1L && (timestamp = System.currentTimeMillis()) > this.nextidleclear) {
            boolean update = false;
            ConcurrentHashMap<CometHandler, CometTask> concurrentHashMap = this.handlers;
            synchronized (concurrentHashMap) {
                if (timestamp > this.nextidleclear) {
                    this.nextidleclear = timestamp + 1000L;
                    update = true;
                }
            }
            if (update) {
                for (CometTask cometTask : this.handlers.values()) {
                    cometTask.setTimeout(timestamp);
                }
            }
        }
    }

    public boolean registerAsyncRead(CometHandler handler) {
        return this.doAsyncRegister(handler, 1);
    }

    public boolean registerAsyncWrite(CometHandler handler) {
        return this.doAsyncRegister(handler, 4);
    }

    private boolean doAsyncRegister(CometHandler handler, int interest) {
        SelectionKey mainKey;
        CometTask task;
        if (handler != null && (task = this.handlers.get(handler)) != null && (mainKey = task.getSelectionKey()) != null) {
            mainKey.interestOps(mainKey.interestOps() | interest);
            task.setComethandlerIsAsyncRegistered(true);
            return true;
        }
        throw ISE;
    }

    public String toString() {
        return this.topic;
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }

    public Set<CometHandler> getCometHandlers() {
        return this.handlers.keySet();
    }

    public boolean isBlockingNotification() {
        return this.blockingNotification;
    }

    public void setBlockingNotification(boolean blockingNotification) {
        this.blockingNotification = blockingNotification;
    }

    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }
}

