/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.container.filter;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPContentEncodingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public ContainerRequest filter(ContainerRequest request) {
        if (request.getRequestHeaders().containsKey("Content-Encoding") && request.getRequestHeaders().getFirst("Content-Encoding").trim().equals("gzip")) {
            request.getRequestHeaders().remove("Content-Encoding");
            try {
                request.setEntityInputStream(new GZIPInputStream(request.getEntityInputStream()));
            }
            catch (IOException ex) {
                throw new ContainerException(ex);
            }
        }
        return request;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        if (response.getEntity() != null && request.getRequestHeaders().containsKey("Accept-Encoding") && !response.getHttpHeaders().containsKey("Content-Encoding") && request.getRequestHeaders().getFirst("Accept-Encoding").contains("gzip")) {
            response.getHttpHeaders().add("Content-Encoding", "gzip");
            response.setContainerResponseWriter(new Adapter(response.getContainerResponseWriter()));
        }
        return response;
    }

    private static final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;
        private GZIPOutputStream gos;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            this.gos = new GZIPOutputStream(this.crw.writeStatusAndHeaders(-1L, response));
            return this.gos;
        }

        public void finish() throws IOException {
            this.gos.finish();
            this.crw.finish();
        }
    }
}

