/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private static final String ATMOSPHERE = "/atmosphere";
    private String atmosphereCtx = "";

    public GrizzlyCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.atmosphereCtx = sc.getServletContext().getContextPath() + ATMOSPHERE;
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext context = cometEngine.register(this.atmosphereCtx);
        context.setExpirationDelay(-1L);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Created CometContext for " + this.atmosphereCtx);
        }
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
            this.suspend(ctx, action, req, res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            this.resume(req, ctx);
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending after Resuming" + res);
                }
                this.suspend(ctx, action, req, res);
            }
        }
        return action;
    }

    private void suspend(CometContext ctx, AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) {
        VoidCometHandler c = new VoidCometHandler(req, res);
        ctx.setExpirationDelay(action.timeout);
        ctx.addCometHandler(c);
        req.setAttribute(ATMOSPHERE, c.hashCode());
        ctx.addAttribute("Time", System.currentTimeMillis());
        if (this.supportSession()) {
            req.getSession().setAttribute(ATMOSPHERE, c.hashCode());
        }
    }

    private void resume(HttpServletRequest req, CometContext ctx) {
        CometHandler handler = ctx.getCometHandler((Integer)req.getAttribute(ATMOSPHERE));
        req.removeAttribute(ATMOSPHERE);
        if (handler == null && this.supportSession()) {
            handler = ctx.getCometHandler((Integer)req.getSession().getAttribute(ATMOSPHERE));
            req.getSession().removeAttribute(ATMOSPHERE);
        }
        if (handler != null) {
            ctx.resumeCometHandler(handler);
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
            CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
            this.resume(actionEvent.getRequest(), ctx);
        }
    }

    private class VoidCometHandler
    implements CometHandler {
        HttpServletRequest req;
        HttpServletResponse res;

        public VoidCometHandler(HttpServletRequest req, HttpServletResponse res) {
            this.req = req;
            this.res = res;
        }

        public void attach(Object o) {
        }

        public void onEvent(CometEvent ce) throws IOException {
        }

        public void onInitialize(CometEvent ce) throws IOException {
        }

        public void onTerminate(CometEvent ce) throws IOException {
        }

        public synchronized void onInterrupt(CometEvent ce) throws IOException {
            long timeStamp = (Long)ce.getCometContext().getAttribute("Time");
            try {
                if (System.currentTimeMillis() - timeStamp >= ce.getCometContext().getExpirationDelay()) {
                    GrizzlyCometSupport.this.timedout(this.req, this.res);
                } else {
                    GrizzlyCometSupport.this.cancelled(this.req, this.res);
                }
            }
            catch (ServletException ex) {
                GrizzlyCometSupport.this.logger.log(Level.WARNING, "", ex);
            }
        }
    }
}

