/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.comet.DefaultNotificationHandler;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometEngine {
    public static final int DISABLE_SUSPEND_TIMEOUT = -1;
    public static final int DISABLE_CLIENT_DISCONNECTION_DETECTION = 0;
    public static final int BEFORE_REQUEST_PROCESSING = 0;
    public static final int AFTER_SERVLET_PROCESSING = 1;
    public static final int AFTER_RESPONSE_PROCESSING = 2;
    protected static final Logger logger = SelectorThread.logger();
    private static final IllegalStateException ISE = new IllegalStateException("Invalid state");
    protected ExtendedThreadPool threadPool;
    protected static final CometEngine cometEngine = new CometEngine();
    protected final ConcurrentHashMap<String, CometContext> activeContexts;
    protected final LinkedTransferQueue<CometContext> cometContextCache = new LinkedTransferQueue();
    private static volatile boolean isCometSupported;
    protected static final ThreadLocal<CometTask> updatedContexts;

    protected CometEngine() {
        this.activeContexts = new ConcurrentHashMap(16, 0.75f, 64);
        FixedThreadPool tpe = new FixedThreadPool(Runtime.getRuntime().availableProcessors(), "CometWorker");
        this.setThreadPool(tpe);
    }

    protected boolean isCometEnabled() {
        return isCometSupported;
    }

    public static CometEngine getEngine() {
        return cometEngine;
    }

    public void setThreadPool(ExtendedThreadPool threadPool) {
        if (threadPool != null) {
            int oldsize = 0;
            if (this.threadPool != null) {
                oldsize = this.threadPool.getMaximumPoolSize();
                this.threadPool.shutdownNow();
            }
            this.threadPool = threadPool;
            int delta = threadPool.getMaximumPoolSize() - oldsize;
            try {
                SelectorFactory.changeSelectorsBy(delta);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "comet failed to resize Selector cache", ex);
            }
        }
    }

    public ExtendedThreadPool getThreadPool() {
        return this.threadPool;
    }

    public CometContext unregister(String topic) {
        CometContext cometContext = this.activeContexts.remove(topic);
        if (cometContext != null) {
            cometContext.recycle();
        }
        return cometContext;
    }

    public CometContext register(String topic) {
        return this.register(topic, 1);
    }

    public CometContext register(String topic, int type) {
        return this.register(topic, type, DefaultNotificationHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CometContext register(String topic, int type, Class<? extends NotificationHandler> notificationClass) {
        CometContext cometContext = this.activeContexts.get(topic);
        if (cometContext == null) {
            ConcurrentHashMap<String, CometContext> concurrentHashMap = this.activeContexts;
            synchronized (concurrentHashMap) {
                cometContext = this.activeContexts.get(topic);
                if (cometContext == null) {
                    cometContext = this.cometContextCache.poll();
                    if (cometContext != null) {
                        cometContext.topic = topic;
                    } else {
                        cometContext = new CometContext(topic, type);
                    }
                    NotificationHandler notificationHandler = null;
                    try {
                        notificationHandler = notificationClass.newInstance();
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Invalid NotificationHandler class : " + notificationClass.getName() + " Using default.", t);
                        notificationHandler = new DefaultNotificationHandler();
                    }
                    cometContext.setNotificationHandler(notificationHandler);
                    if (notificationHandler != null && notificationHandler instanceof DefaultNotificationHandler) {
                        ((DefaultNotificationHandler)notificationHandler).setThreadPool(this.threadPool);
                    }
                    this.activeContexts.put(topic, cometContext);
                }
            }
        }
        cometContext.continuationType = type;
        return cometContext;
    }

    protected boolean handle(AsyncProcessorTask apt) throws IOException {
        String topic;
        if (!isCometSupported) {
            isCometSupported = true;
        }
        CometContext cometContext = (topic = apt.getAsyncExecutor().getProcessorTask().getRequestURI()) == null ? null : this.activeContexts.get(topic);
        int continuationType = cometContext == null ? 1 : cometContext.continuationType;
        this.executeServlet(continuationType, apt);
        CometTask cometTask = updatedContexts.get();
        if (cometTask != null) {
            SelectionKey mainKey;
            updatedContexts.set(null);
            cometContext = cometTask.getCometContext();
            if (cometTask.upcoming_op_isread) {
                cometTask.upcoming_op_isread = false;
                cometContext.addActiveHandler(cometTask);
                return false;
            }
            cometTask.setAsyncProcessorTask(apt);
            if (cometContext.getExpirationDelay() != -1L) {
                cometTask.setTimeout(System.currentTimeMillis());
            }
            if ((mainKey = apt.getAsyncExecutor().getProcessorTask().getSelectionKey()).isValid() && cometContext.getExpirationDelay() != 0L) {
                try {
                    mainKey.interestOps(1);
                    mainKey.attach(cometTask);
                    cometContext.initialize(cometTask.getCometHandler());
                }
                catch (Exception e) {
                    mainKey.attach(Long.MIN_VALUE);
                    return false;
                }
                cometContext.addActiveHandler(cometTask);
                return true;
            }
        }
        return false;
    }

    public CometContext getCometContext(String topic) {
        return this.activeContexts.get(topic);
    }

    protected boolean interrupt(CometTask task, boolean finishExecution) {
        if (task != null && task.getCometContext().handlers().remove(task.cometHandler) != null) {
            SelectionKey key = task.getSelectionKey();
            key.attach(System.currentTimeMillis());
            if (finishExecution) {
                key.cancel();
                task.callInterrupt = true;
                ((WorkerThreadImpl)Thread.currentThread()).getPendingIOhandler().addPendingIO(task);
            } else {
                this.interrupt0(task, finishExecution);
            }
            return true;
        }
        return false;
    }

    protected void interrupt0(CometTask task, boolean finishExecution) {
        if (finishExecution) {
            try {
                task.cometHandler.onInterrupt(task.getCometContext().eventInterrupt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.flushPostExecute(task, finishExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushPostExecute(CometTask task, boolean cancelkey) {
        AsyncProcessorTask apt = task.getAsyncProcessorTask();
        ProcessorTask p = task.getAsyncProcessorTask().getAsyncExecutor().getProcessorTask();
        p.setReRegisterSelectionKey(false);
        p.setAptCancelKey(cancelkey);
        if (apt.getStage() == 2) {
            try {
                CometHandler cometHandler = task.cometHandler;
                synchronized (cometHandler) {
                    apt.doTask();
                }
            }
            catch (IllegalStateException ex) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Resuming Response failed at aptflush", ex);
                }
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "Resuming  failed at aptflush", ex);
            }
        } else {
            logger.warning("APTflush called at wrong stage");
        }
    }

    private void executeServlet(int continuationType, AsyncProcessorTask apt) {
        try {
            switch (continuationType) {
                case 0: {
                    apt.setStage(0);
                    break;
                }
                case 1: {
                    apt.getAsyncExecutor().getProcessorTask().invokeAdapter();
                    return;
                }
                case 2: {
                    apt.setStage(2);
                    apt.doTask();
                    break;
                }
                default: {
                    throw ISE;
                }
            }
            if (apt.getStage() != 2) {
                apt.doTask();
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "executeServlet", ex);
        }
    }

    public static final Logger logger() {
        return logger;
    }

    static {
        updatedContexts = new ThreadLocal();
    }
}

