/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.scanning.uri;

import com.sun.jersey.core.spi.scanning.JarFileScanner;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.spi.scanning.uri.FileSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.UriSchemeScanner;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VfsSchemeScanner
implements UriSchemeScanner {
    @Override
    public Set<String> getSchemes() {
        return new HashSet<String>(Arrays.asList("vfsfile", "vfszip"));
    }

    @Override
    public void scan(URI u, ScannerListener sl) {
        if (u.getScheme().equalsIgnoreCase("vfsfile")) {
            new FileSchemeScanner().scan(UriBuilder.fromUri(u).scheme("file").build(new Object[0]), sl);
        } else {
            String su = u.toString();
            int i = su.indexOf("/WEB-INF/classes");
            if (i != -1) {
                String war = su.substring(0, i).replace("vfszip", "file");
                String path = su.substring(i + 1);
                try {
                    JarFileScanner.scan(new URL(war).openStream(), path, sl);
                }
                catch (IOException ex) {
                    throw new ScannerException("IO error when scanning war " + u, ex);
                }
            }
            try {
                JarFileScanner.scan(new URL(su).openStream(), "", sl);
            }
            catch (IOException ex) {
                throw new ScannerException("IO error when scanning jar " + u, ex);
            }
        }
    }
}

