/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.jboss.servlet.http.HttpEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingIOCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    protected static final String LATCH = "org.atmosphere.container.BlockingIOCometSupport.latch";
    protected ConcurrentHashMap<Integer, CountDownLatch> latchs = new ConcurrentHashMap();

    public BlockingIOCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
            this.suspend(action, req, res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            int latchId;
            CountDownLatch latch;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            if ((latch = this.latchs.get(latchId = ((Integer)req.getSession().getAttribute(LATCH)).intValue())) == null) {
                this.logger.fine("That response " + res + " wasn't suspended.");
                return action;
            }
            latch.countDown();
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND && this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending after Resuming" + res);
                this.suspend(action, req, res);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CountDownLatch latch = new CountDownLatch(1);
        int hash = latch.hashCode();
        req.setAttribute(LATCH, hash);
        this.latchs.put(hash, latch);
        if (this.supportSession()) {
            req.getSession().setAttribute(LATCH, hash);
        }
        try {
            if (action.timeout != -1L) {
                latch.await(action.timeout, TimeUnit.MILLISECONDS);
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
        }
        finally {
            HttpEvent he;
            this.latchs.remove(hash);
            this.timedout(req, res);
            CometEvent event = (CometEvent)req.getAttribute("CometEvent");
            if (event != null) {
                event.close();
            }
            if ((he = (HttpEvent)req.getAttribute("HttpEvent")) != null) {
                he.close();
            }
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        block7: {
            try {
                if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                    int latchId = -1;
                    if (actionEvent.getRequest().getAttribute(LATCH) != null) {
                        latchId = (Integer)actionEvent.getRequest().getAttribute(LATCH);
                    }
                    if (latchId != -1 && this.supportSession() && actionEvent.getRequest().getSession().getAttribute(LATCH) != null) {
                        latchId = (Integer)actionEvent.getRequest().getSession().getAttribute(LATCH);
                    }
                    if (latchId != -1) {
                        CountDownLatch latch = this.latchs.remove(latchId);
                        latch.countDown();
                    } else {
                        this.logger.log(Level.SEVERE, "Unable to resume the suspended connection");
                    }
                }
            }
            catch (Exception ex) {
                if (!this.logger.isLoggable(Level.FINE)) break block7;
                this.logger.log(Level.FINE, "", ex);
            }
        }
    }
}

