/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletAdapter
extends GrizzlyAdapter {
    private static final Logger LOGGER = LoggerUtils.getLogger();
    public static final int REQUEST_RESPONSE_NOTES = 29;
    public static final int SERVLETCONFIG_NOTES = 30;
    public static final String LOAD_ON_STARTUP = "load-on-startup";
    protected volatile Servlet servletInstance = null;
    private transient List<String> listeners = new ArrayList<String>();
    private String servletPath = "";
    private String contextPath = "";
    private boolean loadOnStartup = false;
    private Map<String, String> contextParameters = new HashMap<String, String>();
    private Map<String, String> servletInitParameters = new HashMap<String, String>();
    private volatile boolean filterChainConfigured = false;
    private ReentrantLock filterChainReady = new ReentrantLock();
    private final ServletContextImpl servletCtx;
    private ServletConfigImpl servletConfig;
    protected HashMap<String, Object> properties = new HashMap();
    protected boolean initialize = true;
    protected ClassLoader classLoader;
    private static final Object[] lock = new Object[0];
    private FilterConfigImpl[] filters = new FilterConfigImpl[8];
    public static final int INCREMENT = 8;
    private int n = 0;

    public ServletAdapter() {
        this(".");
    }

    public ServletAdapter(Servlet servlet) {
        this(".");
        this.servletInstance = servlet;
    }

    public ServletAdapter(String publicDirectory) {
        this(publicDirectory, new ServletContextImpl(), new HashMap<String, String>(), new HashMap<String, String>(), new ArrayList<String>());
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, Map<String, String> contextParameters, Map<String, String> servletInitParameters, List<String> listeners) {
        this(publicDirectory, servletCtx, contextParameters, servletInitParameters, listeners, true);
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, Map<String, String> contextParameters, Map<String, String> servletInitParameters, List<String> listeners, boolean initialize) {
        super(publicDirectory);
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx, servletInitParameters);
        this.contextParameters = contextParameters;
        this.servletInitParameters = servletInitParameters;
        this.listeners = listeners;
        this.initialize = initialize;
    }

    protected ServletAdapter(String publicDirectory, ServletContextImpl servletCtx, Map<String, String> contextParameters, Map<String, String> servletInitParameters, boolean initialize) {
        super(publicDirectory);
        this.servletCtx = servletCtx;
        this.servletConfig = new ServletConfigImpl(servletCtx, servletInitParameters);
        this.contextParameters = contextParameters;
        this.servletInitParameters = servletInitParameters;
        this.initialize = initialize;
    }

    public ServletAdapter(Servlet servlet, ServletContextImpl servletContext) {
        super(".");
        this.servletInstance = servlet;
        this.servletCtx = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        block9: {
            try {
                if (this.initialize) {
                    this.initWebDir();
                    this.configureClassLoader(((File)this.fileFolders.peek()).getCanonicalPath());
                }
                if (this.classLoader != null) {
                    ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    try {
                        this.configureServletEnv();
                        this.setResourcesContextPath(this.contextPath);
                        if (this.loadOnStartup) {
                            this.loadServlet();
                        }
                        break block9;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                }
                this.configureServletEnv();
                this.setResourcesContextPath(this.contextPath);
                if (this.loadOnStartup) {
                    this.loadServlet();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "start", t);
            }
        }
    }

    protected void configureClassLoader(String applicationPath) throws IOException {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderUtil.createURLClassLoader(applicationPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.doService(request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            this.doService(request, response);
        }
    }

    public void doService(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            Cookie[] cookies;
            Request req = request.getRequest();
            Response res = response.getResponse();
            String uri = request.getRequestURI();
            if (!uri.startsWith(this.contextPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404);
                return;
            }
            HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)req.getNote(29);
            HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)res.getNote(29);
            if (httpRequest == null) {
                httpRequest = new HttpServletRequestImpl(request);
                httpResponse = new HttpServletResponseImpl(response);
                req.setNote(29, httpRequest);
                res.setNote(29, httpResponse);
            }
            if ((cookies = request.getCookies()) != null) {
                for (Cookie c : cookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    request.setRequestedSessionId(c.getValue());
                    request.setRequestedSessionCookie(true);
                    break;
                }
            }
            this.loadServlet();
            httpRequest.setContextImpl(this.servletCtx);
            httpRequest.setServletPath(this.servletPath);
            httpRequest.initSession();
            httpResponse.addHeader("server", "grizzly/" + Grizzly.getDotedVersion());
            FilterChainImpl filterChain = new FilterChainImpl(this.servletInstance, this.servletConfig);
            filterChain.invokeFilterChain(httpRequest, httpResponse);
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500);
        }
    }

    public void customizeErrorPage(GrizzlyResponse response, String message, int errorCode) {
        response.setStatus(errorCode, message);
        response.setContentType("text/html");
        try {
            response.getWriter().write("<html><body><h1>" + message + "</h1></body></html>");
            response.getWriter().flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadServlet() throws ServletException {
        try {
            this.filterChainReady.lock();
            if (this.filterChainConfigured) {
                return;
            }
            if (this.servletInstance == null) {
                String servletClassName = System.getProperty("com.sun.grizzly.servletClass");
                if (servletClassName != null) {
                    this.servletInstance = (Servlet)ClassLoaderUtil.load(servletClassName);
                }
                if (this.servletInstance != null) {
                    this.logger.info("Loading Servlet: " + this.servletInstance.getClass().getName());
                }
            }
            if (this.servletInstance != null) {
                this.servletInstance.init(this.servletConfig);
            }
            for (FilterConfigImpl f : this.filters) {
                if (f == null) continue;
                f.getFilter().init(f);
            }
            this.filterChainConfigured = true;
        }
        finally {
            this.filterChainReady.unlock();
        }
    }

    protected void configureServletEnv() throws ServletException {
        MessageBytes c = MessageBytes.newInstance();
        if (!this.contextPath.equals("")) {
            char[] ch = this.contextPath.toCharArray();
            c.setChars(ch, 0, ch.length);
            HttpRequestURIDecoder.normalize(c);
            this.contextPath = c.getCharChunk().toString();
        }
        if (this.contextPath.equals("/")) {
            this.contextPath = "";
        }
        if (this.initialize) {
            this.servletCtx.setInitParameter(this.contextParameters);
            this.servletCtx.setContextPath(this.contextPath);
            this.servletCtx.setBasePath(this.getRootFolders().peek());
            this.configureProperties(this.servletCtx);
            this.servletCtx.initListeners(this.listeners);
        }
        this.servletConfig.setInitParameters(this.servletInitParameters);
        this.configureProperties(this.servletConfig);
    }

    @Override
    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        HttpServletRequestImpl httpRequest = (HttpServletRequestImpl)request.getRequest().getNote(29);
        HttpServletResponseImpl httpResponse = (HttpServletResponseImpl)response.getResponse().getNote(29);
        if (httpRequest != null) {
            httpRequest.recycle();
            httpResponse.recycle();
        }
    }

    public void addInitParameter(String name, String value) {
        this.servletInitParameters.put(name, value);
    }

    public void removeInitParameter(String name) {
        this.servletInitParameters.remove(name);
    }

    public String getInitParameter(String name) {
        return this.servletInitParameters.get(name);
    }

    public boolean containsInitParameter(String name) {
        return this.servletInitParameters.containsKey(name);
    }

    public void addContextParameter(String name, String value) {
        this.contextParameters.put(name, value);
    }

    public void addFilter(Filter filter, String filterName, Map initParameters) {
        FilterConfigImpl filterConfig = new FilterConfigImpl(this.servletCtx);
        filterConfig.setFilter(filter);
        filterConfig.setFilterName(filterName);
        filterConfig.setInitParameters(initParameters);
        this.addFilter(filterConfig);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
        if (!servletPath.equals("") && !servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void addServletListener(String listenerName) {
        if (listenerName == null) {
            return;
        }
        this.listeners.add(listenerName);
    }

    public boolean removeServletListener(String listenerName) {
        return listenerName != null && this.listeners.remove(listenerName);
    }

    private void configureProperties(Object object) {
        for (String s : this.properties.keySet()) {
            String value = this.properties.get(s).toString();
            IntrospectionUtils.setProperty(object, s, value);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        int pos;
        if (name.equalsIgnoreCase(LOAD_ON_STARTUP) && value != null) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                this.loadOnStartup = true;
            } else {
                try {
                    if (new Integer(value.toString()) >= 0) {
                        this.loadOnStartup = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if ((pos = name.indexOf("-")) > 0) {
            String pre = name.substring(0, pos);
            String post = name.substring(pos + 1, pos + 2).toUpperCase() + name.substring(pos + 2);
            name = pre + post;
        }
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                super.destroy();
                this.servletCtx.destroyListeners();
                for (FilterConfigImpl filter : this.filters) {
                    if (filter == null) continue;
                    filter.recycle();
                }
                if (this.servletInstance != null) {
                    this.servletInstance.destroy();
                    this.servletInstance = null;
                }
                this.filters = null;
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            super.destroy();
            this.servletCtx.destroyListeners();
        }
    }

    public ServletAdapter newServletAdapter(Servlet servlet) {
        ServletAdapter sa = new ServletAdapter(".", this.servletCtx, this.contextParameters, new HashMap<String, String>(), this.listeners, false);
        if (this.classLoader != null) {
            sa.setClassLoader(this.classLoader);
        }
        sa.setServletInstance(servlet);
        sa.setServletPath(this.servletPath);
        return sa;
    }

    protected ServletContextImpl getServletCtx() {
        return this.servletCtx;
    }

    protected List<String> getListeners() {
        return this.listeners;
    }

    protected Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFilter(FilterConfigImpl filterConfig) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.n == this.filters.length) {
                FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 8];
                System.arraycopy(this.filters, 0, newFilters, 0, this.n);
                this.filters = newFilters;
            }
            this.filters[this.n++] = filterConfig;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final class FilterChainImpl
    implements FilterChain {
        private final Servlet servlet;
        private final ServletConfigImpl configImpl;
        private int pos = 0;

        public FilterChainImpl(Servlet servlet, ServletConfigImpl configImpl) {
            this.servlet = servlet;
            this.configImpl = configImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            ServletRequestEvent event = new ServletRequestEvent(this.configImpl.getServletContext(), request);
            try {
                for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                    try {
                        if (!(l instanceof ServletRequestListener)) continue;
                        ((ServletRequestListener)l).requestInitialized(event);
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR("requestInitialized", "ServletRequestListener", l.getClass().getName()), t);
                    }
                }
                this.pos = 0;
                this.doFilter(request, response);
            }
            finally {
                for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                    try {
                        if (!(l instanceof ServletRequestListener)) continue;
                        ((ServletRequestListener)l).requestDestroyed(event);
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR("requestDestroyed", "ServletRequestListener", l.getClass().getName()), t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.pos < ServletAdapter.this.n) {
                FilterConfigImpl filterConfig;
                Object[] objectArray = lock;
                synchronized (objectArray) {
                    filterConfig = ServletAdapter.this.filters[this.pos++];
                }
                try {
                    Filter filter = filterConfig.getFilter();
                    filter.doFilter(request, response, this);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ServletException("Throwable", e);
                }
                return;
            }
            try {
                if (this.servlet != null) {
                    this.servlet.service(request, response);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException("Throwable", e);
            }
        }

        protected FilterConfigImpl getFilter(int i) {
            return ServletAdapter.this.filters[i];
        }

        protected Servlet getServlet() {
            return this.servlet;
        }

        protected ServletConfigImpl getServletConfig() {
            return this.configImpl;
        }
    }
}

