/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.Serializer;

public class Meteor {
    private static final ConcurrentHashMap<HttpServletRequest, Meteor> cache = new ConcurrentHashMap();
    private final AtmosphereResource<HttpServletRequest, HttpServletResponse> r;
    private Object o;

    private Meteor(AtmosphereResource<HttpServletRequest, HttpServletResponse> r, List<BroadcastFilter> l, Serializer s) {
        this.r = r;
        r.setSerializer(s);
        if (l != null) {
            for (BroadcastFilter f : l) {
                r.getBroadcaster().getBroadcasterConfig().addFilter(f);
            }
        }
        cache.put(r.getRequest(), this);
    }

    public static Meteor lookup(HttpServletRequest r) {
        return cache.get(r);
    }

    public static final Meteor build(HttpServletRequest r) {
        Meteor m = Meteor.lookup(r);
        if (m != null) {
            return m;
        }
        return Meteor.build(r, null);
    }

    public static final Meteor build(HttpServletRequest r, Serializer s) {
        return Meteor.build(r, null, s);
    }

    public static final Meteor build(HttpServletRequest req, List<BroadcastFilter> l, Serializer s) {
        return Meteor.build(req, Broadcaster.SCOPE.APPLICATION, l, s);
    }

    public static final Meteor build(HttpServletRequest req, Broadcaster.SCOPE scope, List<BroadcastFilter> l, Serializer s) {
        AtmosphereResource r = (AtmosphereResource)req.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
        if (r == null) {
            throw new IllegalStateException("MeteorServlet not defined in web.xml");
        }
        Broadcaster b = null;
        if (scope == Broadcaster.SCOPE.REQUEST) {
            try {
                b = BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, DefaultBroadcaster.class.getSimpleName());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            b.setScope(scope);
            r.setBroadcaster(b);
        }
        Meteor m = new Meteor(r, l, s);
        return m;
    }

    public Meteor suspend(long l) {
        this.r.suspend(l);
        return this;
    }

    public Meteor suspend(long l, boolean outputComments) {
        this.r.suspend(l, outputComments);
        return this;
    }

    public Meteor resume() {
        this.r.resume();
        cache.remove(this.r.getRequest());
        return this;
    }

    public Meteor broadcast(Object o) {
        this.r.getBroadcaster().broadcast(o);
        return this;
    }

    public Meteor schedule(Object o, long period) {
        this.r.getBroadcaster().scheduleFixedBroadcast(o, period, TimeUnit.SECONDS);
        return this;
    }

    public Meteor delayBroadadcast(Object o, long period) {
        this.r.getBroadcaster().delayBroadcast(o, period, TimeUnit.SECONDS);
        return this;
    }

    public Broadcaster getBroadcaster() {
        return this.r.getBroadcaster();
    }

    public void setBroadcaster(Broadcaster b) {
        this.r.setBroadcaster(b);
    }

    public Object attachement() {
        return this.o;
    }

    public void attach(Object o) {
        this.o = o;
    }

    public void addListener(AtmosphereResourceEventListener e) {
        if (this.r instanceof AtmosphereEventLifecycle) {
            ((AtmosphereEventLifecycle)((Object)this.r)).addEventListener(e);
        }
    }

    public void removeListener(AtmosphereResourceEventListener e) {
        if (this.r instanceof AtmosphereEventLifecycle) {
            ((AtmosphereEventLifecycle)((Object)this.r)).removeEventListener(e);
        }
    }

    static void destroy() {
        cache.clear();
    }
}

