/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.arp.AsyncTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAsyncExecutor
implements AsyncExecutor {
    private static final String ASYNC_FILTER = "com.sun.grizzly.asyncFilters";
    private static final ArrayList<AsyncFilter> sharedAsyncFilters = DefaultAsyncExecutor.loadFilters();
    private AsyncTask asyncProcessorTask;
    private ProcessorTask processorTask;
    private final ArrayList<AsyncFilter> asyncFilters = new ArrayList<AsyncFilter>(sharedAsyncFilters);
    private AsyncHandler asyncHandler;
    private final AtomicBoolean parseHeaderPhase = new AtomicBoolean(false);
    private final AtomicBoolean executeAdapterPhase = new AtomicBoolean(false);
    private final AtomicBoolean commitResponsePhase = new AtomicBoolean(false);

    @Override
    public boolean preExecute() throws Exception {
        if (!this.parseHeaderPhase.getAndSet(true)) {
            this.processorTask.preProcess();
            if (this.processorTask.parseRequest()) {
                this.finishResponse();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean interrupt() throws Exception {
        if (this.asyncFilters.isEmpty()) {
            this.execute();
            return false;
        }
        AsyncFilter.Result result = this.invokeFilters();
        if (result == AsyncFilter.Result.NEXT) {
            return this.execute();
        }
        return result == AsyncFilter.Result.FINISH;
    }

    @Override
    public boolean execute() throws Exception {
        if (!this.executeAdapterPhase.getAndSet(true)) {
            this.processorTask.invokeAdapter();
            return true;
        }
        return false;
    }

    private AsyncFilter.Result invokeFilters() {
        for (AsyncFilter asyncFilter : this.asyncFilters) {
            AsyncFilter.Result result = asyncFilter.doFilter(this);
            if (result == AsyncFilter.Result.NEXT) continue;
            return result;
        }
        return AsyncFilter.Result.NEXT;
    }

    private void finishResponse() throws Exception {
        this.processorTask.postProcess();
        this.processorTask.terminateProcess();
        this.processorTask = null;
    }

    @Override
    public boolean postExecute() throws Exception {
        if (!this.commitResponsePhase.getAndSet(true)) {
            if (this.processorTask == null) {
                return false;
            }
            this.processorTask.postResponse();
            this.finishResponse();
            return false;
        }
        return false;
    }

    @Override
    public void setAsyncTask(AsyncTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    @Override
    public AsyncTask getAsyncTask() {
        return this.asyncProcessorTask;
    }

    @Override
    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    @Override
    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }

    @Override
    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    @Override
    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    @Override
    public void setProcessorTask(ProcessorTask task) {
        this.processorTask = task;
    }

    @Override
    public ProcessorTask getProcessorTask() {
        return this.processorTask;
    }

    protected static ArrayList<AsyncFilter> loadFilters() {
        ArrayList<AsyncFilter> al = new ArrayList<AsyncFilter>();
        if (System.getProperty(ASYNC_FILTER) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(ASYNC_FILTER), ",");
            while (st.hasMoreTokens()) {
                AsyncFilter filter = (AsyncFilter)ClassLoaderUtil.load(st.nextToken());
                if (filter == null) continue;
                al.add(filter);
            }
        }
        return al;
    }

    void recycle() {
        this.parseHeaderPhase.getAndSet(false);
        this.executeAdapterPhase.getAndSet(false);
        this.commitResponsePhase.getAndSet(false);
    }
}

