/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer;

import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.http.webxml.schema.ContextParam;
import com.sun.grizzly.http.webxml.schema.Filter;
import com.sun.grizzly.http.webxml.schema.FilterMapping;
import com.sun.grizzly.http.webxml.schema.InitParam;
import com.sun.grizzly.http.webxml.schema.Listener;
import com.sun.grizzly.http.webxml.schema.ServletMapping;
import com.sun.grizzly.http.webxml.schema.WebApp;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppAdapter
extends ServletAdapter {
    private static Logger logger = Logger.getLogger("WebAppAdapter");
    private static final String EMPTY_SERVLET_PATH = "";
    private static final String ROOT = "/";
    private Map<GrizzlyAdapter, Set<String>> toRegister = new HashMap<GrizzlyAdapter, Set<String>>();
    private WebApp webApp;
    private ClassLoader webAppCL;
    private String root;
    private String context;

    public WebAppAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppAdapter(String root, String context, WebApp webApp, ClassLoader webAppCL, WebApp webdefault) {
        this.root = root;
        this.context = context;
        this.webApp = webdefault != null ? webApp.mergeWith(webdefault) : webApp;
        this.webAppCL = webAppCL;
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webAppCL);
        try {
            this.initialize();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
    }

    private void initialize() {
        boolean blankContextServletPathFound = false;
        boolean defaultContextServletPathFound = false;
        ArrayList<String> aliasesUsed = new ArrayList<String>();
        for (Map.Entry<ServletAdapter, List<String>> adapterAliases : this.getServletAdaptersToAlises(this.webApp, this.context).entrySet()) {
            ServletAdapter sa = adapterAliases.getKey();
            sa.setClassLoader(this.webAppCL);
            WebAppAdapter.setContextParams(this.webApp, sa);
            WebAppAdapter.setFilters(this.webApp, sa);
            WebAppAdapter.setListeners(this.webApp, sa);
            sa.addRootFolder(this.root);
            String[] alias = WebAppAdapter.getAlias(sa, (Collection<String>)adapterAliases.getValue());
            sa.setHandleStaticResources(false);
            for (String item : alias) {
                if (!item.endsWith(ROOT) && !item.endsWith("/*")) continue;
                sa.setHandleStaticResources(true);
            }
            if (logger.isLoggable(Level.FINEST)) {
                WebAppAdapter.logServletAdapterConfigurationWithAliases(sa, alias);
            }
            List<String> stringList = Arrays.asList(alias);
            aliasesUsed.addAll(stringList);
            this.toRegister.put(sa, new HashSet<String>(stringList));
            if (ROOT.equals(sa.getServletPath())) {
                defaultContextServletPathFound = true;
            }
            if (!EMPTY_SERVLET_PATH.equals(sa.getServletPath())) continue;
            blankContextServletPathFound = true;
        }
        if (!defaultContextServletPathFound) {
            logger.log(Level.FINEST, "Adding a ServletAdapter to handle / path");
            this.createAndInstallServletAdapter(this.root, this.context, ROOT);
        }
        if (!blankContextServletPathFound && !aliasesUsed.contains(this.context + ROOT)) {
            logger.log(Level.FINEST, "Adding a ServletAdapter to handle root path");
            this.createAndInstallServletAdapter(this.root, this.context, EMPTY_SERVLET_PATH);
        }
    }

    private void createAndInstallServletAdapter(String rootFolder, String context, String tmpPath) {
        ServletAdapter sa = new ServletAdapter();
        sa.setContextPath(context);
        sa.setServletPath(tmpPath);
        sa.setHandleStaticResources(true);
        sa.addRootFolder(rootFolder);
        WebAppAdapter.logServletAdapterConfiguration(context, sa);
        this.toRegister.put(sa, Collections.singleton(context + ROOT));
    }

    private static void logServletAdapterConfiguration(String ctx, ServletAdapter sa) {
        if (logger.isLoggable(Level.FINEST)) {
            WebAppAdapter.debugServletAdapterConfiguration(sa, ctx + ROOT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppCL);
        Thread.currentThread().setContextClassLoader(prevCL);
    }

    public Map<ServletAdapter, List<String>> getServletAdaptersToAlises(WebApp webApp, String context) {
        HashMap<ServletAdapter, List<String>> servletAdapterMap;
        if (webApp == null || webApp.getServletMapping() == null || webApp.getServletMapping().isEmpty()) {
            ServletAdapter sa = new ServletAdapter();
            sa.setContextPath(context);
            sa.setServletPath(EMPTY_SERVLET_PATH);
            servletAdapterMap = new HashMap<ServletAdapter, List<String>>(1);
            servletAdapterMap.put(sa, Arrays.asList(ROOT));
        } else {
            List<ServletMapping> mappings = webApp.getServletMapping();
            servletAdapterMap = new HashMap(mappings.size());
            for (ServletMapping servletMapping : mappings) {
                String servletUrlPattern;
                List<String> urlPatternList = servletMapping.getUrlPattern();
                String urlPattern = urlPatternList == null || urlPatternList.isEmpty() ? ROOT : urlPatternList.get(0);
                if (!urlPattern.startsWith(ROOT)) {
                    urlPattern = String.format("%s%s", ROOT, urlPattern);
                }
                if ((servletUrlPattern = urlPattern).indexOf("//") > -1) {
                    servletUrlPattern = servletUrlPattern.replaceAll("//", ROOT);
                }
                ServletAdapter sa = this.createServletAdapter(context, servletUrlPattern);
                WebAppAdapter.setServlet(webApp, sa, servletMapping);
                servletAdapterMap.put(sa, Arrays.asList(urlPattern));
            }
        }
        return servletAdapterMap;
    }

    protected static void setServlet(WebApp webApp, ServletAdapter sa, ServletMapping servletMapping) {
        for (com.sun.grizzly.http.webxml.schema.Servlet servletItem : webApp.getServlet()) {
            if (!servletItem.getServletName().equalsIgnoreCase(servletMapping.getServletName())) continue;
            sa.setServletInstance((Servlet)ClassLoaderUtil.load(servletItem.getServletClass()));
            List<InitParam> initParamsList = servletItem.getInitParam();
            if (initParamsList != null && !initParamsList.isEmpty()) {
                for (InitParam element : initParamsList) {
                    sa.addInitParameter(element.getParamName(), element.getParamValue());
                }
            }
            int loadOnStartup = -1;
            try {
                loadOnStartup = Integer.parseInt(servletItem.loadOnStartup);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (loadOnStartup == -1) break;
            sa.setProperty("load-on-startup", Boolean.TRUE);
            break;
        }
    }

    public static String getServletPath(String path) {
        String result;
        if (path == null) {
            result = ROOT;
        } else {
            result = path.replaceAll("\\\\", ROOT);
            if (!result.startsWith(ROOT)) {
                result = ROOT + result;
            }
            if (result.endsWith(ROOT) && result.length() > 1) {
                result = result.substring(0, result.length() - 1);
            } else if (!result.endsWith(ROOT)) {
                int index = result.lastIndexOf(ROOT);
                if (result.lastIndexOf(42) > index || result.lastIndexOf(46) > index) {
                    if (index == 0) {
                        result = ROOT;
                    } else if (index > 0 && index < result.length()) {
                        result = result.substring(0, index);
                    }
                }
            }
        }
        return result;
    }

    protected ServletAdapter createServletAdapter(String context, String servletUrlPattern) {
        ServletAdapter sa = new ServletAdapter();
        sa.setContextPath(context);
        sa.setServletPath(WebAppAdapter.getServletPath(servletUrlPattern));
        return sa;
    }

    protected static void setFilters(WebApp webApp, ServletAdapter sa) {
        if (webApp == null || sa == null) {
            return;
        }
        List<Filter> filterList = webApp.getFilter();
        List<FilterMapping> filterMappingList = webApp.getFilterMapping();
        if (filterList != null && !filterList.isEmpty()) {
            for (Filter filterItem : filterList) {
                for (FilterMapping filterMapping : filterMappingList) {
                    if (!filterItem.getFilterName().equalsIgnoreCase(filterMapping.getFilterName())) continue;
                    javax.servlet.Filter filter = (javax.servlet.Filter)ClassLoaderUtil.load(filterItem.getFilterClass());
                    List<InitParam> initParamList = filterItem.getInitParam();
                    HashMap<String, String> initParamsMap = new HashMap<String, String>();
                    if (initParamList != null) {
                        for (InitParam param : initParamList) {
                            initParamsMap.put(param.getParamName(), param.getParamValue());
                        }
                    }
                    sa.addFilter(filter, filterItem.getFilterName(), initParamsMap);
                }
            }
        }
    }

    protected static void setListeners(WebApp webApp, ServletAdapter sa) {
        if (webApp == null || sa == null) {
            return;
        }
        List<Listener> listeners = webApp.getListener();
        if (listeners != null) {
            for (Listener element : listeners) {
                sa.addServletListener(element.getListenerClass());
            }
        }
    }

    protected static void setContextParams(WebApp webApp, ServletAdapter sa) {
        if (webApp == null || sa == null) {
            return;
        }
        List<ContextParam> contextParmas = webApp.getContextParam();
        if (contextParmas != null) {
            for (ContextParam element : contextParmas) {
                sa.addContextParameter(element.getParamName(), element.getParamValue());
            }
        }
    }

    public static String[] getAlias(ServletAdapter sa, Collection<String> aliases) {
        List<Object> aliasList;
        if (sa == null || aliases == null) {
            aliasList = Arrays.asList(ROOT);
        } else {
            aliasList = new ArrayList(aliases.size());
            for (String urlPattern : aliases) {
                String aliasTmp;
                String mapping = EMPTY_SERVLET_PATH;
                if (!sa.getServletPath().equals(urlPattern) && urlPattern.indexOf(sa.getServletPath()) > -1) {
                    mapping = urlPattern.substring(urlPattern.indexOf(sa.getServletPath()) + sa.getServletPath().length());
                }
                if ((aliasTmp = String.format("%s%s%s", sa.getContextPath(), sa.getServletPath(), mapping)).indexOf("//") > -1) {
                    aliasTmp = aliasTmp.replaceAll("//", ROOT);
                }
                aliasList.add(aliasTmp);
            }
        }
        return aliasList.toArray(new String[aliasList.size()]);
    }

    static void logServletAdapterConfigurationWithAliases(ServletAdapter sa, String[] aliases) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        for (String item : aliases) {
            sb.append(item).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        WebAppAdapter.debugServletAdapterConfiguration(sa, sb.toString());
    }

    static void debugServletAdapterConfiguration(ServletAdapter sa, String alias) {
        logger.log(Level.FINEST, "sa context=" + sa.getContextPath());
        logger.log(Level.FINEST, "sa servletPath=" + sa.getServletPath());
        logger.log(Level.FINEST, "sa alias=" + alias);
        logger.log(Level.FINEST, "sa rootFolders=" + sa.getRootFolders());
    }

    public Map<GrizzlyAdapter, Set<String>> getToRegister() {
        return this.toRegister;
    }
}

