/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.di.InjectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcaster
implements Broadcaster {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBroadcaster.class);
    protected final ConcurrentLinkedQueue<AtmosphereResource<?, ?>> resources = new ConcurrentLinkedQueue();
    protected BroadcasterConfig bc;
    protected final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    protected String name = DefaultBroadcaster.class.getSimpleName();
    protected final ConcurrentLinkedQueue<Entry> delayedBroadcast = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<Entry> broadcastOnResume = new ConcurrentLinkedQueue();
    protected Future<?> notifierFuture;
    protected BroadcasterCache broadcasterCache;
    private Broadcaster.POLICY policy = Broadcaster.POLICY.FIFO;
    private long maxSuspendResource = -1L;
    private final AtomicBoolean requestScoped = new AtomicBoolean(false);
    private BroadcasterLifeCyclePolicy lifeCyclePolicy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
    private Future<?> currentLifecycleTask;

    public DefaultBroadcaster() {
        this(DefaultBroadcaster.class.getSimpleName());
    }

    public DefaultBroadcaster(String name) {
        this.name = name;
        this.broadcasterCache = new BroadcasterConfig.DefaultBroadcasterCache();
        this.bc = new BroadcasterConfig(AtmosphereServlet.broadcasterFilters, null);
        this.setID(name);
    }

    @Override
    public void destroy() {
        this.releaseExternalResources();
        if (this.notifierFuture != null) {
            this.notifierFuture.cancel(true);
        }
        if (this.bc != null && this.scope != Broadcaster.SCOPE.REQUEST) {
            this.bc.destroy();
        }
        if (this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        this.resources.clear();
        this.broadcastOnResume.clear();
        this.messages.clear();
        this.delayedBroadcast.clear();
        this.broadcasterCache = null;
        this.started.set(false);
        this.destroyed.set(true);
        if (BroadcasterFactory.getDefault() != null) {
            BroadcasterFactory.getDefault().remove(this, this.name);
        }
        if (this.currentLifecycleTask != null) {
            this.currentLifecycleTask.cancel(true);
        }
    }

    @Override
    public Collection<AtmosphereResource<?, ?>> getAtmosphereResources() {
        return Collections.unmodifiableCollection(this.resources);
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
        if (scope != Broadcaster.SCOPE.REQUEST) {
            return;
        }
        try {
            for (AtmosphereResource<?, ?> resource : this.resources) {
                Broadcaster b = BroadcasterFactory.getDefault().get(this.getClass(), this.getClass().getSimpleName() + "/" + UUID.randomUUID());
                if (DefaultBroadcaster.class.isAssignableFrom(this.getClass())) {
                    BroadcasterCache cache = (BroadcasterCache)this.bc.getBroadcasterCache().getClass().newInstance();
                    InjectorProvider.getInjector().inject(cache);
                    ((DefaultBroadcaster)DefaultBroadcaster.class.cast((Object)b)).broadcasterCache = cache;
                }
                resource.setBroadcaster(b);
                if (!resource.getAtmosphereResourceEvent().isSuspended()) continue;
                b.addAtmosphereResource(resource);
            }
            if (!this.resources.isEmpty()) {
                this.destroy();
            }
        }
        catch (Exception e) {
            logger.error("failed to set request scope for current resources", e);
        }
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setID(String id) {
        Broadcaster b = BroadcasterFactory.getDefault().lookup(this.getClass(), id);
        if (b != null && b.getScope() == Broadcaster.SCOPE.REQUEST) {
            throw new IllegalStateException("Broadcaster ID already assigned to SCOPE.REQUEST. Cannot change the id");
        }
        BroadcasterFactory.getDefault().remove(this, this.name);
        this.name = id;
        BroadcasterFactory.getDefault().add(this, this.name);
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public void resumeAll() {
        for (AtmosphereResource<?, ?> r : this.resources) {
            r.resume();
        }
    }

    @Override
    public void releaseExternalResources() {
    }

    @Override
    public void setBroadcasterLifeCyclePolicy(final BroadcasterLifeCyclePolicy lifeCyclePolicy) {
        this.lifeCyclePolicy = lifeCyclePolicy;
        if (this.currentLifecycleTask != null) {
            this.currentLifecycleTask.cancel(false);
        }
        if (lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE || lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY) {
            int time = lifeCyclePolicy.getTimeout();
            if (time == -1) {
                throw new IllegalStateException("BroadcasterLifeCyclePolicy time is not set");
            }
            final AtomicReference ref = new AtomicReference();
            this.currentLifecycleTask = this.bc.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DefaultBroadcaster.this.resources.isEmpty()) {
                            if (lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE) {
                                DefaultBroadcaster.this.releaseExternalResources();
                                logger.debug("Applying BroadcasterLifeCyclePolicy IDLE policy");
                            } else {
                                DefaultBroadcaster.this.destroy();
                                if (ref.get() != null) {
                                    DefaultBroadcaster.this.currentLifecycleTask.cancel(true);
                                }
                                logger.debug("Applying BroadcasterLifeCyclePolicy IDLE_DESTROY policy");
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.warn("Scheduled BroadcasterLifeCyclePolicy exception", t);
                    }
                }
            }, time, time, lifeCyclePolicy.getTimeUnit());
            ref.set(this.currentLifecycleTask);
        }
    }

    protected Runnable getBroadcastHandler() {
        return new Runnable(){

            @Override
            public void run() {
                Entry msg = null;
                try {
                    msg = DefaultBroadcaster.this.messages.take();
                    DefaultBroadcaster.this.bc.getExecutorService().submit(this);
                    DefaultBroadcaster.this.push(msg);
                }
                catch (Throwable ex) {
                    logger.error("failed to submit broadcast handler runnable to broadcast executor service", ex);
                }
            }
        };
    }

    protected void start() {
        if (!this.started.getAndSet(true)) {
            this.broadcasterCache = this.bc.getBroadcasterCache();
            this.broadcasterCache.start();
            this.notifierFuture = this.bc.getExecutorService().submit(this.getBroadcastHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Entry entry) {
        Object finalMsg;
        String prevMessage = entry.message.toString();
        if (!this.delayedBroadcast.isEmpty()) {
            Iterator<Entry> i = this.delayedBroadcast.iterator();
            StringBuilder b = new StringBuilder();
            while (i.hasNext()) {
                Entry e = i.next();
                e.future.cancel(true);
                try {
                    if (e.message instanceof String && entry.message instanceof String) {
                        b.append(e.message);
                        continue;
                    }
                    this.push(e);
                }
                finally {
                    i.remove();
                }
            }
            if (b.length() > 0) {
                entry.message = b.append(entry.message).toString();
            }
        }
        if (this.resources.isEmpty()) {
            this.trackBroadcastMessage(null, entry.message);
            entry.future.done();
            return;
        }
        entry.message = finalMsg = this.translate(entry.message);
        if (entry.multipleAtmoResources == null) {
            for (AtmosphereResource<?, ?> r : this.resources) {
                finalMsg = this.perRequestFilter(r, entry);
                if (!entry.writeLocally) continue;
                this.executeAsyncWrite(r, finalMsg, entry.future);
            }
        } else if (entry.multipleAtmoResources instanceof AtmosphereResource) {
            finalMsg = this.perRequestFilter((AtmosphereResource)entry.multipleAtmoResources, entry);
            if (entry.writeLocally) {
                this.executeAsyncWrite((AtmosphereResource)entry.multipleAtmoResources, finalMsg, entry.future);
            }
        } else if (entry.multipleAtmoResources instanceof Set) {
            Set sub = (Set)entry.multipleAtmoResources;
            for (AtmosphereResource r : sub) {
                finalMsg = this.perRequestFilter(r, entry);
                if (!entry.writeLocally) continue;
                this.executeAsyncWrite(r, finalMsg, entry.future);
            }
        }
        entry.message = prevMessage;
    }

    protected Object perRequestFilter(AtmosphereResource<?, ?> r, Entry msg) {
        Object finalMsg = msg.message;
        if (r.getRequest() instanceof HttpServletRequest && this.bc.hasPerRequestFilters()) {
            Object message = msg.originalMessage;
            BroadcastFilter.BroadcastAction a = this.bc.filter((HttpServletRequest)r.getRequest(), (HttpServletResponse)r.getResponse(), message);
            if (a.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT || a.message() != null) {
                finalMsg = a.message();
            }
        }
        this.trackBroadcastMessage(r, finalMsg);
        return finalMsg;
    }

    private Object translate(Object msg) {
        if (Callable.class.isAssignableFrom(msg.getClass())) {
            try {
                return ((Callable)Callable.class.cast(msg)).call();
            }
            catch (Exception e) {
                logger.error("failed to cast message: " + msg, e);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAsyncWrite(final AtmosphereResource<?, ?> resource, Object msg, final BroadcasterFuture future) {
        AtmosphereResource<?, ?> atmosphereResource = resource;
        synchronized (atmosphereResource) {
            if (resource.getAtmosphereResourceEvent().isCancelled()) {
                return;
            }
            final AtmosphereResourceEvent event = resource.getAtmosphereResourceEvent();
            event.setMessage(msg);
            if (resource.getAtmosphereResourceEvent() != null && !resource.getAtmosphereResourceEvent().isCancelled() && HttpServletRequest.class.isAssignableFrom(resource.getRequest().getClass())) {
                try {
                    ((HttpServletRequest)HttpServletRequest.class.cast(resource.getRequest())).setAttribute(CometSupport.MAX_INACTIVE, System.currentTimeMillis());
                }
                catch (Exception t) {
                    logger.warn("Preventing corruption of a recycled request: resource" + resource, event);
                    this.resources.remove(resource);
                    if (future != null) {
                        future.cancel(true);
                    }
                    return;
                }
            }
            this.bc.getAsyncWriteService().execute(new Runnable(){

                @Override
                public void run() {
                    DefaultBroadcaster.this.broadcast(resource, event);
                    if (resource instanceof AtmosphereEventLifecycle) {
                        ((AtmosphereEventLifecycle)((Object)resource)).notifyListeners();
                    }
                    if (future != null) {
                        future.done();
                    }
                }
            });
        }
    }

    protected void checkCachedAndPush(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        this.retrieveTrackedBroadcast(r, e);
        if (e.getMessage() instanceof List && !((List)e.getMessage()).isEmpty()) {
            this.broadcast(r, e);
        }
    }

    protected boolean retrieveTrackedBroadcast(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        List<Object> missedMsg = this.broadcasterCache.retrieveFromCache(r);
        if (!missedMsg.isEmpty()) {
            e.setMessage(missedMsg);
            return true;
        }
        return false;
    }

    protected void trackBroadcastMessage(AtmosphereResource<?, ?> r, Object msg) {
        this.broadcasterCache.addToCache(r, msg);
    }

    protected void broadcast(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        try {
            r.getAtmosphereConfig().getAtmosphereHandler(this).onStateChange(e);
        }
        catch (IOException ex) {
            if (AtmosphereResourceImpl.class.isAssignableFrom(r.getClass())) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).notifyListeners(e);
            }
            this.onException(ex, r);
        }
        catch (RuntimeException ex) {
            if (AtmosphereResourceImpl.class.isAssignableFrom(r.getClass())) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).notifyListeners(e);
            }
            this.onException(ex, r);
        }
    }

    protected void onException(Throwable t, final AtmosphereResource<?, ?> r) {
        logger.debug("onException()", t);
        if (r instanceof AtmosphereEventLifecycle) {
            ((AtmosphereEventLifecycle)((Object)r)).notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false, t));
            ((AtmosphereEventLifecycle)((Object)r)).removeEventListeners();
        }
        this.bc.getAsyncWriteService().execute(new Runnable(){

            @Override
            public void run() {
                r.resume();
            }
        });
    }

    @Override
    public void setSuspendPolicy(long maxSuspendResource, Broadcaster.POLICY policy) {
        this.maxSuspendResource = maxSuspendResource;
        this.policy = policy;
    }

    @Override
    public <T> Future<T> broadcast(T msg) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer(new Entry(newMsg, null, f, msg));
        return f;
    }

    protected Object filter(Object msg) {
        BroadcastFilter.BroadcastAction a = this.bc.filter(msg);
        if (a.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT || msg == null) {
            return null;
        }
        return a.message();
    }

    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer(new Entry(newMsg, r, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcastOnResume(T msg) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.broadcastOnResume.offer(new Entry(newMsg, null, f, msg));
        return f;
    }

    protected void broadcastOnResume(AtmosphereResource<?, ?> r) {
        for (Entry e : this.broadcastOnResume) {
            e.multipleAtmoResources = r;
            this.push(e);
        }
        if (this.resources.isEmpty()) {
            this.broadcastOnResume.clear();
        }
    }

    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource<?, ?>> subset) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer(new Entry(newMsg, subset, f, msg));
        return f;
    }

    @Override
    public AtmosphereResource<?, ?> addAtmosphereResource(AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        if (this.scope == Broadcaster.SCOPE.REQUEST && this.requestScoped.getAndSet(true)) {
            throw new IllegalStateException("Broadcaster " + this + " cannot be used as its scope is set to REQUEST");
        }
        if (this.maxSuspendResource > 0L && (long)this.resources.size() == this.maxSuspendResource) {
            if (this.policy == Broadcaster.POLICY.FIFO) {
                AtmosphereResource<?, ?> resource = this.resources.poll();
                try {
                    resource.resume();
                }
                catch (Throwable t) {
                    logger.warn("failed to resume resource: " + resource, t);
                }
            } else if (this.policy == Broadcaster.POLICY.REJECT) {
                throw new RejectedExecutionException(String.format("Maximum suspended AtmosphereResources %s", this.maxSuspendResource));
            }
        }
        if (this.resources.contains(r)) {
            return r;
        }
        if (this.resources.isEmpty()) {
            BroadcasterFactory.getDefault().add(this, this.name);
        }
        this.resources.add(r);
        this.checkCachedAndPush(r, r.getAtmosphereResourceEvent());
        return r;
    }

    public AtmosphereResource<?, ?> removeAtmosphereResource(AtmosphereResource r) {
        if (!this.resources.contains(r)) {
            return null;
        }
        this.resources.remove(r);
        if (this.resources.isEmpty()) {
            if (this.lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY) {
                this.releaseExternalResources();
            } else if (this.lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY) {
                BroadcasterFactory.getDefault().remove(this, this.name);
                this.destroy();
            }
        }
        return r;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    @Override
    public <T> Future<T> delayBroadcast(T o) {
        return this.delayBroadcast(o, 0L, null);
    }

    @Override
    public <T> Future<T> delayBroadcast(final T o, long delay, TimeUnit t) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        Object msg = this.filter(o);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> future = new BroadcasterFuture<Object>(msg);
        final Entry e = new Entry(msg, null, future, o);
        if (delay > 0L) {
            ScheduledFuture f = this.bc.getScheduledExecutorService().schedule(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    DefaultBroadcaster.this.delayedBroadcast.remove(e);
                    if (Callable.class.isAssignableFrom(o.getClass())) {
                        try {
                            Object r = ((Callable)Callable.class.cast(o)).call();
                            Object msg = DefaultBroadcaster.this.filter(r);
                            if (msg != null) {
                                Entry entry = new Entry(msg, null, null, r);
                                DefaultBroadcaster.this.push(entry);
                            }
                            return msg;
                        }
                        catch (Exception e1) {
                            logger.error("", e);
                        }
                    }
                    Object msg = DefaultBroadcaster.this.filter(o);
                    Entry e2 = new Entry(msg, null, null, o);
                    DefaultBroadcaster.this.push(e2);
                    return msg;
                }
            }, delay, t);
            e.future = new BroadcasterFuture<Object>(f, msg);
        }
        this.delayedBroadcast.offer(e);
        return future;
    }

    public Future<?> scheduleFixedBroadcast(Object o, long period, TimeUnit t) {
        return this.scheduleFixedBroadcast(o, 0L, period, t);
    }

    public Future<?> scheduleFixedBroadcast(final Object o, long waitFor, long period, TimeUnit t) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        if (period == 0L || t == null) {
            return null;
        }
        Object msg = this.filter(o);
        if (msg == null) {
            return null;
        }
        return this.bc.getScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (Callable.class.isAssignableFrom(o.getClass())) {
                    try {
                        Object r = ((Callable)Callable.class.cast(o)).call();
                        Object msg = DefaultBroadcaster.this.filter(r);
                        if (msg != null) {
                            Entry entry = new Entry(msg, null, null, r);
                            DefaultBroadcaster.this.push(entry);
                        }
                        return;
                    }
                    catch (Exception e) {
                        logger.error("", e);
                    }
                }
                Object msg = DefaultBroadcaster.this.filter(o);
                Entry e = new Entry(msg, null, null, o);
                DefaultBroadcaster.this.push(e);
            }
        }, waitFor, period, t);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "\n" + "\tName: " + this.name + "\n" + "\tScope: " + (Object)((Object)this.scope) + "\n" + "\tBroasdcasterCache " + this.broadcasterCache + "\n" + "\tAtmosphereResource: " + this.resources.size() + "\n";
    }

    public class Entry {
        public Object message;
        public Object multipleAtmoResources;
        public BroadcasterFuture<?> future;
        public boolean writeLocally;
        public Object originalMessage;

        public Entry(Object message, Object multipleAtmoResources, BroadcasterFuture<?> future, Object originalMessage) {
            this.message = message;
            this.multipleAtmoResources = multipleAtmoResources;
            this.future = future;
            this.writeLocally = true;
            this.originalMessage = originalMessage;
        }

        public Entry(Object message, Object multipleAtmoResources, BroadcasterFuture<?> future, boolean writeLocally) {
            this.message = message;
            this.multipleAtmoResources = multipleAtmoResources;
            this.future = future;
            this.writeLocally = writeLocally;
        }

        public String toString() {
            return "Entry{message=" + this.message + ", multipleAtmoResources=" + this.multipleAtmoResources + ", future=" + this.future + '}';
        }
    }
}

