/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.spi.StringReader;
import com.sun.jersey.spi.StringReaderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.jersey.AtmosphereFilter;

public class AtmosphereProviders {

    public static class BroadcasterProvider
    implements StringReaderProvider {
        @Context
        HttpServletRequest req;

        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (!Broadcaster.class.isAssignableFrom(type)) {
                return null;
            }
            return new BroadcasterStringReader();
        }

        @StringReader.ValidateDefaultValue(value=false)
        public class BroadcasterStringReader
        implements StringReader {
            public Object fromString(String topic) {
                Broadcaster broadcaster = null;
                try {
                    AtmosphereResource r = (AtmosphereResource)BroadcasterProvider.this.req.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
                    BroadcasterFactory bp = (BroadcasterFactory)BroadcasterProvider.this.req.getAttribute("org.atmosphere.cpr.broadcasterFactory");
                    broadcaster = bp.lookup(r.getBroadcaster().getClass(), topic, true);
                }
                catch (Throwable ex) {
                    throw new WebApplicationException(ex);
                }
                BroadcasterProvider.this.req.setAttribute(AtmosphereFilter.INJECTED_BROADCASTER, broadcaster);
                return broadcaster;
            }
        }
    }
}

