/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub.spring;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.samples.pubsub.spring.NoOpView;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Controller
@RequestMapping(value={"/"})
public class PubSubController {
    public PubSubController() {
        System.out.println("PubSubController: Constructor - Created!");
    }

    @RequestMapping(produces={"text/html"})
    public String loadPage() {
        return "pubsub.page";
    }

    @RequestMapping(value={"{topic}"}, method={RequestMethod.GET})
    public ModelAndView subscribe(HttpServletRequest request) throws Exception {
        AtmosphereResource resource = (AtmosphereResource)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        this.doGet(resource, request, (HttpServletResponse)resource.getResponse());
        ModelAndView mv = new ModelAndView((View)new NoOpView());
        return mv;
    }

    @RequestMapping(value={"{topic}"}, method={RequestMethod.POST})
    public ModelAndView broadcastMessage(HttpServletRequest request) throws Exception {
        this.doPost(request);
        ModelAndView mv = new ModelAndView((View)new NoOpView());
        return mv;
    }

    private void doGet(AtmosphereResource r, HttpServletRequest req, HttpServletResponse res) {
        r.addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
        res.setContentType("text/html;charset=ISO-8859-1");
        Broadcaster b = this.lookupBroadcaster((AtmosphereRequest)AtmosphereRequest.class.cast(req));
        r.setBroadcaster(b);
        String header = req.getHeader("X-Atmosphere-Transport");
        if ("long-polling".equalsIgnoreCase(header)) {
            req.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)Boolean.TRUE);
            r.suspend(-1L);
        } else {
            r.suspend(-1L);
        }
    }

    private void doPost(HttpServletRequest req) throws IOException {
        Broadcaster b = this.lookupBroadcaster((AtmosphereRequest)AtmosphereRequest.class.cast(req));
        String message = req.getReader().readLine();
        if (message != null && message.indexOf("message") != -1) {
            b.broadcast((Object)message.substring("message=".length()));
        }
    }

    Broadcaster lookupBroadcaster(AtmosphereRequest request) {
        String pathInfo = request.getPathInfo();
        BroadcasterFactory factory = request.resource().getAtmosphereConfig().getBroadcasterFactory();
        if (pathInfo == null) {
            return factory.lookup((Object)"/", true);
        }
        String[] decodedPath = pathInfo.split("/");
        return factory.lookup((Object)decodedPath[decodedPath.length - 1], true);
    }
}

