/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub.config.protocol;

import java.io.IOException;
import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.samples.pubsub.config.SpringApplicationContext;
import org.atmosphere.samples.pubsub.dto.BaseCommand;
import org.atmosphere.samples.pubsub.dto.Command;
import org.atmosphere.samples.pubsub.dto.EmptyCommand;
import org.atmosphere.samples.pubsub.services.ChatService;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingWebSocketProtocol
implements WebSocketProtocol {
    public static final Logger LOG = LoggerFactory.getLogger(DelegatingWebSocketProtocol.class);

    public void configure(AtmosphereConfig atmosphereConfig) {
    }

    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String message) {
        if (webSocket.resource() == null) {
            return null;
        }
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        resource.suspend();
        ChatService chatService = (ChatService)SpringApplicationContext.getBean(ChatService.class);
        ObjectMapper mapper = (ObjectMapper)SpringApplicationContext.getBean(ObjectMapper.class);
        Command command = this.readCommand(message, mapper);
        command.setResource((AtmosphereResource)resource);
        chatService.execute(command);
        return null;
    }

    private Command readCommand(String s, ObjectMapper mapper) {
        EmptyCommand command = new EmptyCommand();
        try {
            command = (Command)mapper.readValue(s, BaseCommand.class);
        }
        catch (IOException e) {
            LOG.error("Exception converting JSON:", (Throwable)e);
        }
        return command;
    }

    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] bytes, int offset, int length) {
        return this.onMessage(webSocket, new String(bytes, offset, length));
    }

    public void onOpen(WebSocket webSocket) {
        LOG.debug("opened web socket connection {}", (Object)webSocket);
    }

    public void onClose(WebSocket webSocket) {
        LOG.debug("closing web socket connection {}", (Object)webSocket);
    }

    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException e) {
        LOG.error("error on websocket connection {}", (Throwable)e);
    }
}

