/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub.services;

import com.google.common.collect.Maps;
import java.util.Map;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.samples.pubsub.dto.Command;
import org.atmosphere.samples.pubsub.services.ChatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChatService {
    private static final Logger LOG = LoggerFactory.getLogger(ChatService.class);
    private Map<String, Thread> runningPublishers = Maps.newConcurrentMap();

    public void execute(Command command) {
        Broadcaster broadcaster = command.getResource().getAtmosphereConfig().getBroadcasterFactory().lookup(DefaultBroadcaster.class, (Object)command.getChannel(), true);
        command.execute(broadcaster);
        if (!broadcaster.isDestroyed() && !this.isRunningThreadOnChannel(command.getChannel())) {
            this.startMessagingThread(command.getChannel(), broadcaster);
        }
    }

    private synchronized boolean isRunningThreadOnChannel(String channel) {
        return this.runningPublishers.containsKey(channel) && ((Thread)this.runningPublishers.get(channel)).isAlive();
    }

    private synchronized void startMessagingThread(String channel, Broadcaster broadcaster) {
        Thread thread = new Thread((Runnable)new ChannelPublisher(this, broadcaster, channel));
        thread.start();
        this.runningPublishers.put(channel, thread);
    }

    static /* synthetic */ Map access$000(ChatService x0) {
        return x0.runningPublishers;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

