/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.stomp.pubsub;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.atmosphere.config.service.Heartbeat;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.stomp.annotation.StompEndpoint;
import org.atmosphere.stomp.annotation.StompService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StompEndpoint
public class StompEndpointSample {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Heartbeat
    public void onHeartbeat(AtmosphereResourceEvent event) {
        this.log.info("Heartbeat received from {}", (Object)event);
    }

    @StompService(destination="/destination-1")
    public String destination1(String body) throws IOException {
        String now = new SimpleDateFormat("HH:mm:ss").format(new Date());
        return String.format("%s - value '%s' returned from method mapped to /destination-1", now, body);
    }

    @StompService(destination="/destination-2")
    public String destination2(String body) throws IOException {
        String now = new SimpleDateFormat("HH:mm:ss").format(new Date());
        return String.format("%s - value '%s' returned from method mapped to /destination-2", now, body);
    }

    @StompService(destination="/destination-3")
    public String destination3(String body) throws IOException {
        String now = new SimpleDateFormat("HH:mm:ss").format(new Date());
        return String.format("%s - value '%s' returned from method mapped to /destination-3", now, body);
    }
}

