/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.tictactoe;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.samples.tictactoe.TTTGame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTTHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private static TTTGame game = new TTTGame();
    private final AtomicInteger counter = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtmosphereEvent onEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        HttpServletRequest req = (HttpServletRequest)event.getRequest();
        HttpServletResponse res = (HttpServletResponse)event.getResponse();
        res.setContentType("text/html");
        res.addHeader("Cache-Control", "private");
        res.addHeader("Pragma", "no-cache");
        if (req.getMethod().equalsIgnoreCase("GET")) {
            res.getWriter().write("<!-- Comet is a programming technique that enables web servers to send data to the client without having any need for the client to request it. -->\n");
            res.getWriter().flush();
            event.suspend();
        }
        if (req.getMethod().equalsIgnoreCase("POST")) {
            TTTGame tTTGame = game;
            synchronized (tTTGame) {
                int cell = -1;
                String cellStr = req.getParameter("cell");
                PrintWriter writer = res.getWriter();
                writer.println("cell is '" + cellStr + "'");
                if (cellStr == null) {
                    writer.println("error - cell not set");
                    return event;
                }
                try {
                    cell = Integer.parseInt(cellStr);
                }
                catch (NumberFormatException nfe) {
                    writer.println("error - cellStr not an int: " + cellStr);
                    return event;
                }
                if (!game.turn(cell)) {
                    writer.println("warning - invalid move");
                }
                writer.println(game.getJSON());
                Broadcaster bc = event.getBroadcaster();
                String response = game.getJSON();
                bc.broadcast((Object)response);
                writer.flush();
                if (game.win() != -1) {
                    game = new TTTGame();
                }
            }
        }
        return event;
    }

    public AtmosphereEvent onMessage(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        if (event.isCancelled()) {
            return event;
        }
        String response = (String)event.getMessage();
        response = "<script type='text/javascript'>parent.chImg(" + response + ")</script>\n";
        PrintWriter writer = ((HttpServletResponse)event.getResponse()).getWriter();
        writer.write(response);
        writer.flush();
        if (!event.isResumedOnTimeout()) {
            event.resume();
        }
        return event;
    }
}

