/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.tictactoe;

public class TTTGame {
    public static final int X = 10;
    public static final int O = 1;
    int[] board = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    int turnNum = 0;
    int[][] wins = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {0, 3, 6}, {1, 4, 7}, {2, 5, 8}, {0, 4, 8}, {2, 4, 6}};
    int winner = -1;

    public boolean turn(int cell) {
        if (cell < 0 || cell > 8) {
            return false;
        }
        if (this.winner != -1) {
            return false;
        }
        if (this.board[cell] != 0) {
            return false;
        }
        ++this.turnNum;
        this.board[cell] = this.turnNum % 2 == 1 ? 10 : 1;
        return true;
    }

    private int whoseTurn() {
        if (this.turnNum == 0 || this.turnNum % 2 == 0) {
            return 10;
        }
        return 1;
    }

    private boolean done() {
        return this.turnNum > 8;
    }

    public int win() {
        if (this.winner != -1) {
            return this.winner;
        }
        for (int i = 0; i < 8; ++i) {
            int winSum = this.board[this.wins[i][0]] + this.board[this.wins[i][1]] + this.board[this.wins[i][2]];
            if (winSum == 3) {
                this.winner = 2;
                continue;
            }
            if (winSum != 30) continue;
            this.winner = 1;
        }
        if (this.winner == -1 && this.turnNum > 8) {
            this.winner = 0;
        }
        return this.winner;
    }

    private int[] getBoard() {
        return this.board;
    }

    public String getJSON() {
        String response = "{\"win\": \"" + this.win() + "\", \"board\": [";
        for (int i = 0; i < 9; ++i) {
            response = response + "\"" + this.board[i] + "\"";
            if (i >= 8) continue;
            response = response + ",";
        }
        response = response + "]," + "\"turn\": " + this.whoseTurn() + " }";
        return response;
    }
}

