/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.tictactoe;

import java.io.IOException;
import java.io.PrintWriter;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.samples.tictactoe.TTTGame;

public class TTTHandler
implements AtmosphereHandler {
    private static TTTGame game = new TTTGame();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(AtmosphereResource event) throws IOException {
        AtmosphereRequest req = event.getRequest();
        AtmosphereResponse res = event.getResponse();
        res.setContentType("text/html");
        res.addHeader("Cache-Control", "private");
        res.addHeader("Pragma", "no-cache");
        if (req.getMethod().equalsIgnoreCase("GET")) {
            event.suspend();
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            TTTGame tTTGame = game;
            synchronized (tTTGame) {
                int cell = -1;
                String cellStr = req.getParameter("cell");
                PrintWriter writer = res.getWriter();
                writer.println("cell is '" + cellStr + "'");
                if (cellStr == null) {
                    writer.println("error - cell not set");
                    return;
                }
                try {
                    cell = Integer.parseInt(cellStr);
                }
                catch (NumberFormatException nfe) {
                    writer.println("error - cellStr not an int: " + cellStr);
                    return;
                }
                if (!game.turn(cell)) {
                    writer.println("warning - invalid move");
                }
                writer.println(game.getJSON());
                Broadcaster bc = event.getBroadcaster();
                String response = game.getJSON();
                bc.broadcast((Object)response);
                writer.flush();
                if (game.win() != -1) {
                    game = new TTTGame();
                }
            }
        }
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        if (event.isCancelled()) {
            return;
        }
        if (!event.isResumedOnTimeout()) {
            String response = (String)event.getMessage();
            response = "<script type='text/javascript'>parent.chImg(" + response + ")</script>\n";
            PrintWriter writer = event.getResource().getResponse().getWriter();
            writer.write(response);
            writer.flush();
            event.getResource().resume();
        }
    }

    public void destroy() {
    }
}

