/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.twitter;

import com.ning.http.client.AsyncHttpClient;
import com.sun.jersey.spi.resource.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.SuspendResponse;
import org.atmosphere.samples.twitter.EventsLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/search/{tagid}")
@Produces(value={"text/html;charset=ISO-8859-1"})
@Singleton
public class TwitterFeed {
    private final AsyncHttpClient asyncClient = new AsyncHttpClient();
    private final ConcurrentHashMap<String, Future<?>> futures = new ConcurrentHashMap();

    @GET
    public SuspendResponse<String> search(@PathParam(value="tagid") Broadcaster feed, @PathParam(value="tagid") String tagid) {
        if (tagid.isEmpty()) {
            throw new WebApplicationException();
        }
        if (feed.getAtmosphereResources().size() == 0) {
            Future future = feed.scheduleFixedBroadcast((Object)new /* Unavailable Anonymous Inner Class!! */, 1L, TimeUnit.SECONDS);
            this.futures.put(tagid, future);
        }
        return new SuspendResponse.SuspendResponseBuilder().broadcaster(feed).outputComments(true).addListener((AtmosphereResourceEventListener)new EventsLogger()).build();
    }

    @GET
    @Path(value="stop")
    public String stopSearch(@PathParam(value="tagid") Broadcaster feed, @PathParam(value="tagid") String tagid) {
        feed.resumeAll();
        ((Future)this.futures.get(tagid)).cancel(true);
        return "DONE";
    }

    static /* synthetic */ AsyncHttpClient access$100(TwitterFeed x0) {
        return x0.asyncClient;
    }
}

