/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.twitter;

import com.ning.http.client.AsyncHttpClient;
import com.sun.jersey.spi.resource.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.SuspendResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search/{tagid}")
@Produces(value={"text/html;charset=ISO-8859-1"})
@Singleton
public class TwitterFeed {
    private static final Logger logger = LoggerFactory.getLogger(TwitterFeed.class);
    private final AsyncHttpClient asyncClient = new AsyncHttpClient();
    private final ConcurrentHashMap<String, Future<?>> futures = new ConcurrentHashMap();
    private final CountDownLatch suspendLatch = new CountDownLatch(1);

    @GET
    public SuspendResponse<String> search(@PathParam(value="tagid") Broadcaster feed, @PathParam(value="tagid") String tagid) {
        if (tagid.isEmpty()) {
            throw new WebApplicationException();
        }
        if (feed.getAtmosphereResources().size() == 0) {
            Future future = feed.scheduleFixedBroadcast((Object)new /* Unavailable Anonymous Inner Class!! */, 5L, TimeUnit.SECONDS);
            this.futures.put(tagid, future);
        }
        return new SuspendResponse.SuspendResponseBuilder().broadcaster(feed).outputComments(true).addListener((AtmosphereResourceEventListener)new /* Unavailable Anonymous Inner Class!! */).build();
    }

    @GET
    @Path(value="stop")
    public String stopSearch(@PathParam(value="tagid") Broadcaster feed, @PathParam(value="tagid") String tagid) {
        feed.resumeAll();
        if (this.futures.get(tagid) != null) {
            ((Future)this.futures.get(tagid)).cancel(true);
        }
        logger.info("Stopping real time update for {}", (Object)tagid);
        return "DONE";
    }

    static /* synthetic */ CountDownLatch access$000(TwitterFeed x0) {
        return x0.suspendLatch;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ AsyncHttpClient access$300(TwitterFeed x0) {
        return x0.asyncClient;
    }
}

