/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.twitter;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterAtmosphereHandler
extends AbstractReflectorAtmosphereHandler {
    private int counter;
    private static final String BEGIN_SCRIPT_TAG = "<script type='text/javascript'>\n";
    private static final String END_SCRIPT_TAG = "</script>\n";
    private static final Logger logger = LoggerUtils.getLogger();
    private static final long serialVersionUID = -2919167206889576860L;
    private String startingMessage = "<html><head><title>Twitter</title></head><body bgcolor=\"#FFFFFF\">";
    private String endingMessage = "Twitter closed<br/>\n</body></html>";

    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> onEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        HttpServletResponse response = (HttpServletResponse)event.getResponse();
        String action = request.getParameter("action");
        String sessionId = request.getSession().getId();
        HttpSession session = request.getSession();
        Broadcaster myBroadcasterFollower = (Broadcaster)session.getAttribute(sessionId);
        if (action != null) {
            if ("login".equals(action)) {
                response.setContentType("text/plain");
                response.setHeader("Cache-Control", "private");
                response.setHeader("Pragma", "no-cache");
                response.setCharacterEncoding("UTF-8");
                String name = request.getParameter("name");
                if (name == null) {
                    logger.severe("Name cannot be null");
                    return event;
                }
                session.setAttribute("name", (Object)name);
                myBroadcasterFollower.broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp("Welcome back", name) + END_SCRIPT_TAG));
                event.getAtmosphereConfig().getServletContext().setAttribute(name, (Object)myBroadcasterFollower);
            } else if ("post".equals(action)) {
                String message = request.getParameter("message");
                String callback = request.getParameter("callback");
                if (message == null) {
                    logger.severe("Message cannot be null");
                    return event;
                }
                if (callback == null) {
                    callback = "alert";
                }
                if (myBroadcasterFollower != null) {
                    myBroadcasterFollower.broadcast((Object)("<script id='comet_" + this.counter++ + "'>" + "window.parent." + callback + "(" + message + ");</script>"));
                }
                response.getWriter().println("ok");
            } else if ("start".equals(action)) {
                String message = "{ message : 'Welcome'}";
                response.setContentType("text/html");
                String callback = request.getParameter("callback");
                if (callback == null) {
                    callback = "alert";
                }
                response.getWriter().println("<script id='comet_" + this.counter++ + "'>" + "window.parent." + callback + "(" + message + ");</script>");
                response.getWriter().println(this.startingMessage);
                response.getWriter().flush();
                event.setBroadcaster((Broadcaster)new DefaultBroadcaster());
                myBroadcasterFollower = event.getBroadcaster();
                session.setAttribute("event", event);
                session.setAttribute(sessionId, (Object)myBroadcasterFollower);
                event.suspend();
            } else if ("following".equals(action)) {
                response.setContentType("text/html");
                String follow = request.getParameter("message");
                String name = (String)session.getAttribute("name");
                if (follow == null) {
                    logger.severe("Message cannot be null");
                    return event;
                }
                if (name == null) {
                    logger.severe("Name cannot be null");
                    return event;
                }
                Broadcaster outsiderBroadcaster = (Broadcaster)event.getAtmosphereConfig().getServletContext().getAttribute(follow);
                AtmosphereEvent e = (AtmosphereEvent)session.getAttribute("event");
                if (outsiderBroadcaster == null) {
                    myBroadcasterFollower.broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp("Invalid Twitter user ", follow) + END_SCRIPT_TAG), e);
                    return event;
                }
                outsiderBroadcaster.addAtmosphereEvent(e);
                myBroadcasterFollower.broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp("You are now following ", follow) + END_SCRIPT_TAG), e);
                outsiderBroadcaster.broadcast((Object)(BEGIN_SCRIPT_TAG + this.toJsonp(name, " is now following " + follow) + END_SCRIPT_TAG));
            }
        }
        return event;
    }

    private String escape(String orig) {
        StringBuffer buffer = new StringBuffer(orig.length());
        block13: for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    continue block13;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block13;
                }
                case '\n': {
                    buffer.append("<br />");
                    continue block13;
                }
                case '\r': {
                    continue block13;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block13;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block13;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block13;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block13;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block13;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block13;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block13;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private String toJsonp(String name, String message) {
        return "window.parent.app.update({ name: \"" + this.escape(name) + "\", message: \"" + this.escape(message) + "\" });\n";
    }
}

