/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.webrtc;

import java.io.IOException;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereHandlerService
public class AtmosphereHandlerPubSub
extends AbstractReflectorAtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereHandlerPubSub.class);

    public void onRequest(AtmosphereResource r) throws IOException {
        AtmosphereRequest req = r.getRequest();
        AtmosphereResponse res = r.getResponse();
        String method = req.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            r.addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
            res.setContentType("text/html;charset=ISO-8859-1");
            Broadcaster b = this.lookupBroadcaster(r);
            r.setBroadcaster(b);
            if (req.getHeader("X-Atmosphere-Transport").equalsIgnoreCase("long-polling")) {
                req.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)Boolean.TRUE);
                r.suspend();
            } else {
                r.suspend(-1L);
            }
        } else if ("POST".equalsIgnoreCase(method)) {
            Broadcaster b = this.lookupBroadcaster(r);
            String message = req.getReader().readLine();
            if (message != null && message.indexOf("message") != -1) {
                logger.info("Sending message {} to channel {}", new Object[]{message.substring("message=".length()), b.getID()});
                b.broadcast((Object)message.substring("message=".length()));
            }
        }
    }

    public void destroy() {
    }

    Broadcaster lookupBroadcaster(AtmosphereResource ar) {
        String pathInfo = ar.getRequest().getPathInfo();
        String[] decodedPath = pathInfo.split("/");
        Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)decodedPath[decodedPath.length - 1], true);
        return b;
    }
}

