/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.samples.chat.WebSocketChat;
import org.atmosphere.util.SimpleBroadcaster;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketHandlerAdapter;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocketHandlerService(path="/chat", broadcaster=SimpleBroadcaster.class)
public class WebSocketChat
extends WebSocketHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(WebSocketChat.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public void onOpen(WebSocket webSocket) throws IOException {
        webSocket.resource().setBroadcaster(BroadcasterFactory.getDefault().lookup((Object)"/chat", true));
        webSocket.resource().addEventListener((AtmosphereResourceEventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onTextMessage(WebSocket webSocket, String message) throws IOException {
        AtmosphereResource r = webSocket.resource();
        Broadcaster b = r.getBroadcaster();
        b.broadcast((Object)this.mapper.writeValueAsString(this.mapper.readValue(message, Data.class)));
    }

    static /* synthetic */ Logger access$000(WebSocketChat x0) {
        return x0.logger;
    }
}

