/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.samples.chat.WebSocketChat;
import org.atmosphere.util.SimpleBroadcaster;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketHandlerAdapter;
import org.codehaus.jackson.map.ObjectMapper;

@WebSocketHandlerService(path="/chat", broadcaster=SimpleBroadcaster.class)
public class WebSocketChat
extends WebSocketHandlerAdapter {
    private final ObjectMapper mapper = new ObjectMapper();

    public void onOpen(WebSocket webSocket) throws IOException {
        webSocket.resource().setBroadcaster(BroadcasterFactory.getDefault().lookup((Object)"/chat", true));
    }

    public void onTextMessage(WebSocket webSocket, String message) throws IOException {
        AtmosphereResource r = webSocket.resource();
        Broadcaster b = r.getBroadcaster();
        b.broadcast((Object)this.mapper.writeValueAsString(this.mapper.readValue(message, Data.class)));
    }
}

