/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;
import org.atmosphere.websocket.WebSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketPubSub
extends WebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketPubSub.class);

    public void onTextMessage(WebSocket webSocket, String message) {
        AtmosphereResource r = webSocket.resource();
        Broadcaster b = this.lookupBroadcaster(r.getRequest().getPathInfo());
        if (message != null && message.indexOf("message") != -1) {
            b.broadcast((Object)message.substring("message=".length()));
        }
    }

    public void onOpen(WebSocket webSocket) {
        AtmosphereResource r = webSocket.resource();
        Broadcaster b = this.lookupBroadcaster(r.getRequest().getPathInfo());
        r.setBroadcaster(b);
        r.addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
        r.suspend(-1L);
    }

    Broadcaster lookupBroadcaster(String pathInfo) {
        String[] decodedPath = pathInfo.split("/");
        Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)decodedPath[decodedPath.length - 1], true);
        return b;
    }
}

