/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketPubSub
implements WebSocketProtocol {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketPubSub.class);

    public void configure(AtmosphereServlet.AtmosphereConfig config) {
    }

    public AtmosphereRequest onMessage(WebSocket webSocket, String message) {
        AtmosphereResource r = webSocket.resource();
        Broadcaster b = this.lookupBroadcaster(((HttpServletRequest)r.getRequest()).getPathInfo());
        if (message != null && message.indexOf("message") != -1) {
            b.broadcast((Object)message.substring("message=".length()));
        }
        return null;
    }

    public AtmosphereRequest onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        return null;
    }

    public void onOpen(WebSocket webSocket) {
        AtmosphereResource r = webSocket.resource();
        Broadcaster b = this.lookupBroadcaster(((HttpServletRequest)r.getRequest()).getPathInfo());
        r.setBroadcaster(b);
        r.addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
        r.suspend(-1L);
    }

    public void onClose(WebSocket webSocket) {
        webSocket.resource().resume();
    }

    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.error(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }

    Broadcaster lookupBroadcaster(String pathInfo) {
        String[] decodedPath = pathInfo.split("/");
        Broadcaster b = BroadcasterFactory.getDefault().lookup((Object)decodedPath[decodedPath.length - 1], true);
        return b;
    }

    public boolean inspectResponse() {
        return false;
    }

    public String handleResponse(AtmosphereResponse<?> res, String message) {
        return message;
    }

    public byte[] handleResponse(AtmosphereResponse<?> res, byte[] message, int offset, int length) {
        return message;
    }
}

