/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.wicket;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.markup.html.WebPage;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushPage
extends WebPage
implements AtmosphereResourceEventListener {
    private final AtomicBoolean scheduleStarted = new AtomicBoolean(false);

    public PushPage() {
        HttpServletRequest req = this.getWebRequestCycle().getWebRequest().getHttpServletRequest();
        Meteor meteor = Meteor.build((HttpServletRequest)req);
        if (!this.scheduleStarted.getAndSet(true)) {
            meteor.schedule((Object)new /* Unavailable Anonymous Inner Class!! */, 1L);
        }
        meteor.addListener((AtmosphereResourceEventListener)this);
        String transport = req.getHeader("X-Atmosphere-Transport");
        meteor.suspend(-1L, transport == null || !transport.equalsIgnoreCase("long-polling"));
    }

    public void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        LoggerUtils.getLogger().log(Level.INFO, "onBroadcast: " + event.getMessage());
        String transport = ((HttpServletRequest)event.getResource().getRequest()).getHeader("X-Atmosphere-Transport");
        if (transport != null && transport.equalsIgnoreCase("long-polling")) {
            Meteor meteor = Meteor.lookup((HttpServletRequest)((HttpServletRequest)event.getResource().getRequest()));
            meteor.removeListener((AtmosphereResourceEventListener)this);
            meteor.resume();
        }
    }

    public void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        String transport = ((HttpServletRequest)event.getResource().getRequest()).getHeader("X-Atmosphere-Transport");
        HttpServletRequest req = (HttpServletRequest)event.getResource().getRequest();
        LoggerUtils.getLogger().log(Level.INFO, String.format("Suspending the %s response from ip %s:%s", transport == null ? "websocket" : transport, req.getRemoteAddr(), req.getRemotePort()));
    }

    public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        String transport = ((HttpServletRequest)event.getResource().getRequest()).getHeader("X-Atmosphere-Transport");
        HttpServletRequest req = (HttpServletRequest)event.getResource().getRequest();
        LoggerUtils.getLogger().log(Level.INFO, String.format("Resuming the %s response from ip %s:%s", transport == null ? "websocket" : transport, req.getRemoteAddr(), req.getRemotePort()));
    }

    public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        String transport = ((HttpServletRequest)event.getResource().getRequest()).getHeader("X-Atmosphere-Transport");
        HttpServletRequest req = (HttpServletRequest)event.getResource().getRequest();
        LoggerUtils.getLogger().log(Level.INFO, String.format("%s connection dropped from ip %s:%s", transport == null ? "websocket" : transport, req.getRemoteAddr(), req.getRemotePort()));
    }
}

