/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.wicket;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.markup.html.WebPage;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Meteor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushPage
extends WebPage
implements AtmosphereResourceEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PushPage.class);
    private final AtomicBoolean scheduleStarted = new AtomicBoolean(false);

    public PushPage() {
        HttpServletRequest req = this.getWebRequestCycle().getWebRequest().getHttpServletRequest();
        Meteor meteor = Meteor.build((HttpServletRequest)req);
        if (!this.scheduleStarted.getAndSet(true)) {
            meteor.schedule((Object)new /* Unavailable Anonymous Inner Class!! */, 1L);
        }
        meteor.addListener((AtmosphereResourceEventListener)this);
        String transport = req.getHeader("X-Atmosphere-Transport");
        meteor.suspend(-1L, transport == null || !transport.equalsIgnoreCase("long-polling"));
    }

    public void onBroadcast(AtmosphereResourceEvent event) {
        logger.info("onBroadcast(): {}", event.getMessage());
        String transport = event.getResource().getRequest().getHeader("X-Atmosphere-Transport");
        if (transport != null && transport.equalsIgnoreCase("long-polling")) {
            Meteor meteor = Meteor.lookup((HttpServletRequest)event.getResource().getRequest());
            meteor.removeListener((AtmosphereResourceEventListener)this);
            meteor.resume();
        }
    }

    public void onSuspend(AtmosphereResourceEvent event) {
        String transport = event.getResource().getRequest().getHeader("X-Atmosphere-Transport");
        AtmosphereRequest req = event.getResource().getRequest();
        logger.info("Suspending the %s response from ip {}:{}", new Object[]{transport == null ? "websocket" : transport, req.getRemoteAddr(), req.getRemotePort()});
    }

    public void onResume(AtmosphereResourceEvent event) {
        String transport = event.getResource().getRequest().getHeader("X-Atmosphere-Transport");
        AtmosphereRequest req = event.getResource().getRequest();
        logger.info("Resuming the {} response from ip {}:{}", new Object[]{transport == null ? "websocket" : transport, req.getRemoteAddr(), req.getRemotePort()});
    }

    public void onDisconnect(AtmosphereResourceEvent event) {
        String transport = event.getResource().getRequest().getHeader("X-Atmosphere-Transport");
        AtmosphereRequest req = event.getResource().getRequest();
        logger.info("{} connection dropped from ip {}:{}", new Object[]{transport == null ? "websocket" : transport, req.getRemoteAddr(), req.getRemotePort()});
    }

    public void onThrowable(AtmosphereResourceEvent event) {
        logger.info("onThrowable()", event.throwable());
    }
}

