/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.gwt20.jackson.JacksonSerializerProvider;
import org.atmosphere.gwt20.server.SerializationException;
import org.atmosphere.gwt20.server.ServerSerializer;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

public class JsonAtmosphereHandler
extends AbstractReflectorAtmosphereHandler {
    static final Logger logger = Logger.getLogger("AtmosphereHandler");
    private ServerSerializer serializer = new JacksonSerializerProvider().getServerSerializer();

    public void onRequest(AtmosphereResource ar) throws IOException {
        if (ar.getRequest().getMethod().equals("GET")) {
            this.doGet(ar);
        } else if (ar.getRequest().getMethod().equals("POST")) {
            this.doPost(ar);
        }
    }

    public void doGet(AtmosphereResource ar) {
        ar.getResponse().setCharacterEncoding(ar.getRequest().getCharacterEncoding());
        ar.getResponse().setContentType("application/json");
        ar.setBroadcaster(ar.getAtmosphereConfig().getBroadcasterFactory().lookup((Object)"MyBroadcaster", true));
        ar.setSerializer((Serializer)new /* Unavailable Anonymous Inner Class!! */);
        ar.suspend();
    }

    public void doPost(AtmosphereResource ar) throws IOException {
        StringBuilder data = new StringBuilder();
        try {
            BufferedReader requestReader = ar.getRequest().getReader();
            char[] buf = new char[5120];
            int read = -1;
            while ((read = requestReader.read(buf)) > 0) {
                data.append(buf, 0, read);
            }
            logger.info("Received json message from client: " + data.toString());
            Object message = this.serializer.deserialize(data.toString());
            ar.getAtmosphereConfig().getBroadcasterFactory().lookup((Object)"MyBroadcaster").broadcast(message);
        }
        catch (SerializationException ex) {
            logger.log(Level.SEVERE, "Failed to read request data", ex);
        }
    }

    public void destroy() {
    }

    static /* synthetic */ ServerSerializer access$000(JsonAtmosphereHandler x0) {
        return x0.serializer;
    }
}

