/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.server;

import java.util.logging.Logger;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.gwt20.managed.AtmosphereMessageInterceptor;
import org.atmosphere.gwt20.server.GwtRpcInterceptor;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.atmosphere.interceptor.IdleResourceInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;

@ManagedService(path="/GwtRpcDemo/atmosphere/rpc", interceptors={AtmosphereResourceLifecycleInterceptor.class, TrackMessageSizeInterceptor.class, GwtRpcInterceptor.class, SuspendTrackerInterceptor.class, AtmosphereMessageInterceptor.class, BroadcastOnPostAtmosphereInterceptor.class, IdleResourceInterceptor.class})
public class ManagedGWTResource {
    static final Logger logger = Logger.getLogger("AtmosphereHandler");

    @Ready
    public void onReady(AtmosphereResource r) {
        logger.info("Received RPC GET");
        BroadcasterFactory.getDefault().lookup((Object)"Connected users", true).addAtmosphereResource(r).broadcast((Object)("Browser UUID: " + r.uuid() + " connected."));
    }

    @Disconnect
    public void disconnected(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            logger.info("User:" + event.getResource().uuid() + " unexpectedly disconnected");
        } else if (event.isClosedByClient()) {
            logger.info("User:" + event.getResource().uuid() + " closed the connection");
        }
    }

    @Post
    public void post(AtmosphereResource r) {
        logger.info("POST received with transport + " + r.transport());
    }
}

