/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.springboot;

import java.util.Collections;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.ContainerInitializer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableAutoConfiguration
public class AtmosphereApplication {
    @Bean
    public EmbeddedAtmosphereInitializer atmosphereInitializer() {
        return new EmbeddedAtmosphereInitializer();
    }

    @Bean
    public ServletRegistrationBean atmosphereServlet() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new AtmosphereServlet(), new String[]{"/chat/*"});
        registration.addInitParameter("org.atmosphere.cpr.packages", "sample");
        registration.addInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.clientHeartbeatFrequencyInSeconds", "10");
        registration.setLoadOnStartup(0);
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(AtmosphereApplication.class, (String[])args);
    }

    private static class EmbeddedAtmosphereInitializer
    extends ContainerInitializer
    implements ServletContextInitializer {
        private EmbeddedAtmosphereInitializer() {
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            this.onStartup(Collections.emptySet(), servletContext);
        }
    }

    @Configuration
    static class MvcConfiguration
    extends WebMvcConfigurerAdapter {
        MvcConfiguration() {
        }

        public void addViewControllers(ViewControllerRegistry registry) {
            registry.addViewController("/").setViewName("forward:/home/home.html");
        }
    }
}

