/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.springboot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.samples.springboot.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedService(path="/chat")
public class ChatService {
    private final Logger logger = LoggerFactory.getLogger(ChatService.class);

    @Ready
    public void onReady(AtmosphereResource resource) {
        this.logger.info("Connected", (Object)resource.uuid());
    }

    @Disconnect
    public void onDisconnect(AtmosphereResourceEvent event) {
        this.logger.info("Client {} disconnected [{}]", (Object)event.getResource().uuid(), (Object)(event.isCancelled() ? "cancelled" : "closed"));
    }

    @org.atmosphere.config.service.Message(encoders={JacksonEncoderDecoder.class}, decoders={JacksonEncoderDecoder.class})
    public Message onMessage(Message message) throws IOException {
        this.logger.info("Author {} sent message {}", (Object)message.getAuthor(), (Object)message.getMessage());
        return message;
    }

    public static class JacksonEncoderDecoder
    implements Encoder<Message, String>,
    Decoder<String, Message> {
        private final ObjectMapper mapper = new ObjectMapper();

        public String encode(Message m) {
            try {
                return this.mapper.writeValueAsString((Object)m);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Message decode(String s) {
            try {
                return (Message)this.mapper.readValue(s, Message.class);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

