/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.ByteArrayAsyncWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class VertxAsyncIOWriter
extends AtmosphereInterceptorWriter {
    private static final Logger logger = LoggerFactory.getLogger(VertxAsyncIOWriter.class);
    private final AtomicInteger pendingWrite = new AtomicInteger();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ByteArrayAsyncWriter buffer = new ByteArrayAsyncWriter();
    private long lastWrite = 0L;
    private final HttpServerResponse out;
    private boolean headerWritten = false;

    public VertxAsyncIOWriter(HttpServerRequest request) {
        this.out = request.response();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public AsyncIOWriter writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        logger.error("Error {}:{}", (Object)errorCode, (Object)message);
        this.out.write(message);
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
        byte[] b = data.getBytes(r.getCharacterEncoding());
        this.write(r, b);
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
        this.write(r, data, 0, data.length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] transform(AtmosphereResponse response, byte[] b, int offset, int length) throws IOException {
        AsyncIOWriter a = response.getAsyncIOWriter();
        try {
            response.asyncIOWriter((AsyncIOWriter)this.buffer);
            this.invokeInterceptor(response, b, offset, length);
            byte[] byArray = this.buffer.stream().toByteArray();
            return byArray;
        }
        finally {
            this.buffer.close(null);
            response.asyncIOWriter(a);
        }
    }

    public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        boolean transform;
        logger.trace("Writing {} with transport {}", (Object)r.resource().uuid(), (Object)r.resource().transport());
        boolean bl = transform = this.filters.size() > 0 && r.getStatus() < 400;
        if (transform) {
            data = this.transform(r, data, offset, length);
            offset = 0;
            length = data.length;
        }
        this.pendingWrite.incrementAndGet();
        if (!this.headerWritten) {
            this.out.setChunked(true);
            this.constructStatusAndHeaders(r, this.out);
            this.headerWritten = true;
        }
        String sdata = new String(data, offset, length, r.getCharacterEncoding());
        this.out.write(sdata);
        this.lastWrite = System.currentTimeMillis();
        AtmosphereResourceImpl impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r.resource());
        if (sdata.trim().length() > 0 && impl.transport().equals((Object)AtmosphereResource.TRANSPORT.LONG_POLLING)) {
            this.close(r);
        }
        return this;
    }

    public long lastTick() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    public void close(AtmosphereResponse r) throws IOException {
        if (!this.isClosed.getAndSet(true)) {
            try {
                this.out.end();
            }
            catch (IllegalStateException ex) {
                logger.trace("", (Throwable)ex);
            }
        }
    }

    private void constructStatusAndHeaders(AtmosphereResponse response, HttpServerResponse out) {
        Map headers = response.headers();
        String contentType = response.getContentType();
        out.putHeader("Content-Type", contentType != null ? contentType : "text/plain");
        for (Map.Entry s : headers.entrySet()) {
            out.putHeader((String)s.getKey(), (String)s.getValue());
        }
    }
}

