/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.action;

import java.util.Collections;
import java.util.List;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;

public abstract class AbstractActions<T>
implements Actions<T> {
    private final Actions.Options options;
    protected final List<Action<T>> actionList;

    protected AbstractActions() {
        this(new Actions.Options());
    }

    protected AbstractActions(Actions.Options o) {
        this.options = new Actions.Options(o);
        this.actionList = this.createList();
    }

    protected abstract List<Action<T>> createList();

    @Override
    public Actions<T> add(Action<T> action) {
        if (!this.disabled()) {
            if (this.options.memory() && this.fired()) {
                this.fireOne(action, this.cached());
            }
            if (!this.options.unique() || this.options.unique() && !this.actionList.contains(action)) {
                this.actionList.add(action);
            }
        }
        return this;
    }

    protected abstract T cached();

    @Override
    public Actions<T> disable() {
        if (this.setDisabled()) {
            this.actionList.clear();
        }
        return this;
    }

    protected abstract boolean setDisabled();

    @Override
    public Actions<T> empty() {
        this.actionList.clear();
        return this;
    }

    @Override
    public Actions<T> fire() {
        return this.fire(null);
    }

    @Override
    public Actions<T> fire(T data) {
        if (!(this.disabled() || this.options.once() && this.fired())) {
            this.setFired();
            if (this.options.memory()) {
                this.setCache(data);
            }
            for (int i = 0; i < this.actionList.size(); ++i) {
                this.fireOne(this.actionList.get(i), data);
            }
        }
        return this;
    }

    protected abstract void setFired();

    protected abstract void setCache(T var1);

    @Override
    public boolean has() {
        return !this.actionList.isEmpty();
    }

    @Override
    public boolean has(Action<T> action) {
        return this.actionList.contains(action);
    }

    @Override
    public Actions<T> remove(Action<T> action) {
        this.actionList.removeAll(Collections.singleton(action));
        return this;
    }

    protected void fireOne(Action<T> action, T data) {
        action.on(data);
    }
}

