/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.bridge.vertx2;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.http.AbstractServerHttpExchange;
import org.atmosphere.vibe.platform.http.HttpStatus;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class VertxServerHttpExchange
extends AbstractServerHttpExchange {
    private final HttpServerRequest request;
    private final HttpServerResponse response;

    public VertxServerHttpExchange(HttpServerRequest request) {
        this.request = request;
        this.response = request.response();
        request.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable t) {
                VertxServerHttpExchange.this.errorActions.fire((Object)t);
            }
        });
        ((HttpServerResponse)this.response.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable t) {
                VertxServerHttpExchange.this.errorActions.fire((Object)t);
            }
        })).closeHandler((Handler)new VoidHandler(){

            protected void handle() {
                VertxServerHttpExchange.this.closeActions.fire();
            }
        }).setChunked(true);
    }

    public String uri() {
        return this.request.uri();
    }

    public String method() {
        return this.request.method();
    }

    public Set<String> headerNames() {
        return this.request.headers().names();
    }

    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    protected void doRead(final Action<ByteBuffer> chunkAction) {
        ((HttpServerRequest)this.request.dataHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer body) {
                chunkAction.on((Object)body.getByteBuf().nioBuffer());
            }
        })).endHandler((Handler)new VoidHandler(){

            protected void handle() {
                VertxServerHttpExchange.this.endActions.fire();
            }
        });
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatusCode(status.code()).setStatusMessage(status.reason());
    }

    protected void doSetHeader(String name, String value) {
        this.response.putHeader(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        this.response.write(new Buffer().setBytes(0, byteBuffer));
    }

    protected void doEnd() {
        this.response.end();
    }

    public <T> T unwrap(Class<T> clazz) {
        return HttpServerRequest.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.request) : null;
    }
}

