/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.jwa1;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.server.AbstractServerWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwaServerWebSocket
extends AbstractServerWebSocket {
    private final Logger logger = LoggerFactory.getLogger(JwaServerWebSocket.class);
    private final Session session;
    private final Semaphore semaphore = new Semaphore(1, true);

    public JwaServerWebSocket(Session session) {
        this.session = session;
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                JwaServerWebSocket.this.messageActions.fire((Object)new Data(message));
            }
        });
    }

    Actions<Void> closeActions() {
        return this.closeActions;
    }

    Actions<Throwable> errorActions() {
        return this.errorActions;
    }

    public String uri() {
        URI uri = this.session.getRequestURI();
        return uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    protected void doClose() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doSend(ByteBuffer byteBuffer) {
        try {
            this.semaphore.acquireUninterruptibly();
            this.session.getAsyncRemote().sendBinary(byteBuffer, (SendHandler)new WriteResult(byteBuffer));
        }
        catch (IllegalStateException e) {
            this.semaphore.release();
            this.errorActions.fire((Object)e);
        }
    }

    protected void doSend(String data) {
        try {
            this.semaphore.acquireUninterruptibly();
            this.session.getAsyncRemote().sendText(data, (SendHandler)new WriteResult(data));
        }
        catch (IllegalStateException e) {
            this.semaphore.release();
            this.errorActions.fire((Object)e);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return Session.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.session) : null;
    }

    private final class WriteResult
    implements SendHandler {
        private final Object message;

        private WriteResult(Object message) {
            this.message = message;
        }

        public void onResult(SendResult result) {
            JwaServerWebSocket.this.semaphore.release();
            if (!result.isOK() || result.getException() != null) {
                JwaServerWebSocket.this.logger.warn("WebSocket {} failed to write {}", (Object)JwaServerWebSocket.this.session, this.message);
            }
        }
    }
}

