/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.jwa1;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.SimpleActions;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.atmosphere.vibe.platform.server.jwa1.JwaServerWebSocket;

public class JwaBridge {
    private static final Map<String, JwaBridge> bridges = new ConcurrentHashMap<String, JwaBridge>();
    private final String id = UUID.randomUUID().toString();
    private final ServerEndpointConfig config;
    private Actions<ServerWebSocket> wsActions = new SimpleActions();

    public JwaBridge(String path) {
        this.config = ServerEndpointConfig.Builder.create(BridgeEndpoint.class, (String)path).build();
        this.config.getUserProperties().put("bridge.id", this.id);
        bridges.put(this.id, this);
    }

    public ServerEndpointConfig config() {
        return this.config;
    }

    public JwaBridge websocketAction(Action<ServerWebSocket> action) {
        this.wsActions.add(action);
        return this;
    }

    public static class BridgeEndpoint
    extends Endpoint {
        private Map<String, JwaServerWebSocket> webSockets = new ConcurrentHashMap<String, JwaServerWebSocket>();

        public void onOpen(Session session, EndpointConfig config) {
            final String id = session.getId();
            JwaServerWebSocket ws = new JwaServerWebSocket(session);
            ws.closeAction((Action)new VoidAction(){

                public void on() {
                    BridgeEndpoint.this.webSockets.remove(id);
                }
            });
            this.webSockets.put(id, ws);
            ((JwaBridge)bridges.get(config.getUserProperties().get("bridge.id"))).wsActions.fire((Object)ws);
        }

        public void onClose(Session session, CloseReason closeReason) {
            this.webSockets.get(session.getId()).closeActions().fire();
        }

        public void onError(Session session, Throwable thr) {
            this.webSockets.get(session.getId()).errorActions().fire((Object)thr);
        }
    }
}

