/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.play2;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.atmosphere.vibe.platform.server.AbstractServerWebSocket;
import play.libs.F;
import play.mvc.Http;
import play.mvc.WebSocket;

public class PlayServerWebSocket
extends AbstractServerWebSocket {
    private final Http.Request request;
    private final WebSocket.Out<String> out;

    public PlayServerWebSocket(Http.Request request, WebSocket.In<String> in, WebSocket.Out<String> out) {
        this.request = request;
        this.out = out;
        in.onMessage((F.Callback)new F.Callback<String>(){

            public void invoke(String message) throws Throwable {
                PlayServerWebSocket.this.textActions.fire((Object)message);
            }
        });
        in.onClose(new F.Callback0(){

            public void invoke() throws Throwable {
                PlayServerWebSocket.this.closeActions.fire();
            }
        });
    }

    public String uri() {
        return this.request.uri();
    }

    protected void doClose() {
        this.out.close();
    }

    protected void doSend(String data) {
        this.out.write((Object)data);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        this.out.write((Object)new String(bytes, Charset.forName("UTF-8")));
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(Http.Request.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (WebSocket.Out.class.isAssignableFrom(clazz) ? clazz.cast(this.out) : null));
    }
}

