/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.play2;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.server.AbstractServerHttpExchange;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

public class PlayServerHttpExchange
extends AbstractServerHttpExchange {
    private final Http.Request request;
    private final Http.Response response;
    private boolean aborted;
    private CountDownLatch written = new CountDownLatch(1);
    private List<String> buffer = new ArrayList<String>();
    private HttpStatus status = HttpStatus.OK;
    private Results.Chunks.Out<String> out;

    public PlayServerHttpExchange(Http.Request request, Http.Response response) {
        this.request = request;
        this.response = response;
    }

    public F.Promise<Result> result() {
        return F.Promise.promise((F.Function0)new F.Function0<Result>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Result apply() throws Throwable {
                PlayServerHttpExchange.this.written.await();
                PlayServerHttpExchange playServerHttpExchange = PlayServerHttpExchange.this;
                synchronized (playServerHttpExchange) {
                    return Results.status((int)PlayServerHttpExchange.this.status.code(), (Results.Chunks)new Results.StringChunks(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onReady(Results.Chunks.Out<String> out) {
                            PlayServerHttpExchange playServerHttpExchange = PlayServerHttpExchange.this;
                            synchronized (playServerHttpExchange) {
                                PlayServerHttpExchange.this.out = out;
                                out.onDisconnected(new F.Callback0(){

                                    public void invoke() throws Throwable {
                                        PlayServerHttpExchange.this.closeActions.fire();
                                    }
                                });
                                for (String data : PlayServerHttpExchange.this.buffer) {
                                    out.write((Object)data);
                                }
                                if (PlayServerHttpExchange.this.aborted) {
                                    out.close();
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public String uri() {
        return this.request.uri();
    }

    public String method() {
        return this.request.method();
    }

    public Set<String> headerNames() {
        return this.request.headers().keySet();
    }

    public List<String> headers(String name) {
        for (String h : this.request.headers().keySet()) {
            if (!name.toLowerCase().equals(h.toLowerCase())) continue;
            return Arrays.asList((Object[])this.request.headers().get(h));
        }
        return Collections.emptyList();
    }

    protected void readAsText() {
        this.chunkActions.fire((Object)this.request.body().asText());
        this.endActions.fire();
    }

    protected void readAsBinary() {
        this.chunkActions.fire((Object)ByteBuffer.wrap(this.request.body().asRaw().asBytes()));
        this.endActions.fire();
    }

    private void throwIfWritten() {
        if (this.written.getCount() == 0L) {
            this.errorActions.fire((Object)new IllegalStateException("Response has already been written"));
        }
    }

    protected void doSetStatus(HttpStatus status) {
        this.throwIfWritten();
        this.status = status;
    }

    protected void doSetHeader(String name, String value) {
        this.throwIfWritten();
        if (name.equalsIgnoreCase("Content-Type")) {
            name = "Content-Type";
        }
        this.response.setHeader(name, value);
    }

    protected void doWrite(String data) {
        if (this.out == null) {
            this.written.countDown();
            this.buffer.add(data);
        } else {
            this.out.write((Object)data);
        }
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        try {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            this.doWrite(new String(bytes, 0, bytes.length, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doEnd() {
        if (this.out == null) {
            this.written.countDown();
            this.aborted = true;
        } else {
            this.out.close();
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(Http.Request.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (Http.Response.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null));
    }
}

