/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.vertx2;

import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.SimpleActions;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.atmosphere.vibe.platform.server.vertx2.VertxServerHttpExchange;
import org.atmosphere.vibe.platform.server.vertx2.VertxServerWebSocket;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.http.impl.WebSocketMatcher;

public class VertxBridge {
    private Actions<ServerHttpExchange> httpActions = new SimpleActions();
    private Actions<ServerWebSocket> wsActions = new SimpleActions();

    public VertxBridge(final HttpServer server, String path) {
        RouteMatcher httpMatcher = new RouteMatcher();
        httpMatcher.all(path, (Handler)new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest req) {
                VertxBridge.this.httpActions.fire((Object)new VertxServerHttpExchange(req));
            }
        });
        httpMatcher.noMatch(server.requestHandler());
        server.requestHandler((Handler)httpMatcher);
        WebSocketMatcher wsMatcher = new WebSocketMatcher();
        wsMatcher.addPattern(path, (Handler)new Handler<WebSocketMatcher.Match>(){

            public void handle(WebSocketMatcher.Match match) {
                VertxBridge.this.wsActions.fire((Object)new VertxServerWebSocket(match.ws));
            }
        });
        wsMatcher.noMatch((Handler)new Handler<WebSocketMatcher.Match>(){
            Handler<org.vertx.java.core.http.ServerWebSocket> old;
            {
                this.old = server.websocketHandler();
            }

            public void handle(WebSocketMatcher.Match match) {
                if (this.old != null) {
                    this.old.handle((Object)match.ws);
                }
            }
        });
        server.websocketHandler((Handler)wsMatcher);
    }

    public VertxBridge httpAction(Action<ServerHttpExchange> action) {
        this.httpActions.add(action);
        return this;
    }

    public VertxBridge websocketAction(Action<ServerWebSocket> action) {
        this.wsActions.add(action);
        return this;
    }
}

