/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.vertx2;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.server.AbstractServerHttpExchange;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class VertxServerHttpExchange
extends AbstractServerHttpExchange {
    private final HttpServerRequest request;

    public VertxServerHttpExchange(HttpServerRequest request) {
        this.request = request;
        request.response().setChunked(true).closeHandler((Handler)new VoidHandler(){

            protected void handle() {
                VertxServerHttpExchange.this.closeActions.fire();
            }
        });
    }

    public String uri() {
        return this.request.uri();
    }

    public String method() {
        return this.request.method();
    }

    public Set<String> headerNames() {
        return this.request.headers().names();
    }

    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    protected void readBody() {
        this.request.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer body) {
                VertxServerHttpExchange.this.bodyActions.fire((Object)new Data(body.toString()));
            }
        });
    }

    protected void doSetHeader(String name, String value) {
        this.request.response().putHeader(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        this.request.response().write(new Buffer().setBytes(0, byteBuffer));
    }

    protected void doSetStatus(HttpStatus status) {
        this.request.response().setStatusCode(status.code()).setStatusMessage(status.reason());
    }

    protected void doWrite(String data) {
        this.request.response().write(data);
    }

    protected void doClose() {
        this.request.response().end();
        this.request.response().close();
        this.closeActions.fire();
    }

    public <T> T unwrap(Class<T> clazz) {
        return HttpServerRequest.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.request) : null;
    }
}

